% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_expand.R
\name{bm_expand}
\alias{bm_expand}
\alias{bm_expand.bm_bitmap}
\alias{bm_expand.bm_list}
\alias{bm_expand.bm_pixmap}
\alias{bm_expand.magick-image}
\alias{bm_expand.nativeRaster}
\alias{bm_expand.raster}
\title{Expand bitmaps by repeating each row and/or column}
\usage{
bm_expand(x, width = 1L, height = width)

\method{bm_expand}{bm_bitmap}(x, width = 1L, height = width)

\method{bm_expand}{bm_list}(x, ...)

\method{bm_expand}{bm_pixmap}(x, width = 1L, height = width)

\method{bm_expand}{`magick-image`}(x, width = 1L, height = width)

\method{bm_expand}{nativeRaster}(x, width = 1L, height = width)

\method{bm_expand}{raster}(x, width = 1L, height = width)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{width}{An integer of how many times to repeat each column.}

\item{height}{An integer of how many times to repeat each row.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
\code{bm_expand()} expands bitmap(s) by repeating each row and/or column
an indicated number of times.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r)
 print(bm_expand(capital_r, 2L),
       px = px_ascii)
 print(bm_expand(capital_r, width = 1L, height = 2L),
       px = px_ascii)
 print(bm_expand(capital_r, width = 2L, height = 1L),
       px = px_ascii)
crops <- farming_crops_16x16()
corn <- crops$corn$portrait
corn_2x <- bm_expand(corn, 2L)
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_2x, compress = "v")
}
}
\seealso{
\code{\link[=bm_extend]{bm_extend()}} (and \code{\link[=bm_resize]{bm_resize()}} which makes larger bitmaps
by adding pixels to their sides.
}
