% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_starter_pack.R
\name{bs_get_starter_pack}
\alias{bs_get_starter_pack}
\title{Get information on one starter pack}
\usage{
bs_get_starter_pack(
  starter_pack,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{starter_pack}{Character vector, length 1. URI of starter pack to get.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of starter packs
}
\description{
Get information on one starter pack
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getStarterPack.json}{graph/getStarterPack.json (2024-11-20)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-11-20)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_starter_pack(
  'at://did:plc:wpe35pganb6d4pg4ekmfy6u5/app.bsky.graph.starterpack/3lb3g5veo2z2r'
)
\dontshow{\}) # examplesIf}
}
\concept{graph}
