% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xrf.R
\name{axe-xrf}
\alias{axe-xrf}
\alias{axe_call.xrf}
\alias{axe_env.xrf}
\title{Axing a xrf.}
\usage{
\method{axe_call}{xrf}(x, verbose = FALSE, ...)

\method{axe_env}{xrf}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed xrf object.
}
\description{
Axing a xrf.
}
\examples{
\dontshow{if (rlang::is_installed("xrf")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(xrf)

xrf_big <- function() {
  boop <- runif(1e6)
  xrf(
    mpg ~ .,
    mtcars,
    xgb_control = list(nrounds = 2, max_depth = 2),
    family = 'gaussian'
  )
}

heavy_m <- xrf_big()

m <- butcher(heavy_m, verbose = TRUE)

weigh(heavy_m)
weigh(m)
\dontshow{\}) # examplesIf}
}
