% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_radio_button}
\alias{calcite_radio_button}
\title{Create a RadioButton component}
\usage{
calcite_radio_button(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a RadioButton component
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   checked \tab checked \tab When \code{true}, the component is checked. \tab boolean \tab TRUE \cr
   disabled \tab disabled \tab When \code{true}, interaction is prevented and the component is displayed with lower opacity. \tab boolean \tab TRUE \cr
   form \tab form \tab The \code{id} of the form that will be associated with the component.  When not set, the component will be associated with its ancestor form element, if any. \tab string \tab TRUE \cr
   name \tab name \tab Specifies the name of the component. Can be inherited from \code{calcite-radio-button-group}.  Required to pass the component's \code{value} on form submission. \tab string \tab TRUE \cr
   required \tab required \tab When \code{true} and the component resides in a form, the component must have a value selected from the \code{calcite-radio-button-group} in order for the form to submit. \tab boolean \tab TRUE \cr
   scale \tab scale \tab Specifies the size of the component inherited from the \code{calcite-radio-button-group}. \tab "l" | "m" | "s" \tab TRUE \cr
   value \tab value \tab The component's value. \tab any \tab FALSE \cr
}

}

\subsection{Events}{

The following events are observed by shiny:\tabular{ll}{
   Event \tab Description \cr
   calciteRadioButtonChange \tab Fires only when the radio button is checked.  This behavior is identical to the native HTML input element. Since this event does not fire when the radio button is unchecked, it's not recommended to attach a listener for this event directly on the element, but instead either attach it to a node that contains all of the radio buttons in the group or use the \code{calciteRadioButtonGroupChange} event if using this with \code{calcite-radio-button-group}. \cr
}

}
}
\examples{
calcite_radio_button()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/radio-button/}{Official Documentation}
}
