% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_taxon.R
\name{update_taxon}
\alias{update_taxon}
\title{Update a taxon}
\usage{
update_taxon(x, from, to)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{from}{\code{scientificName} of the taxon to update.}

\item{to}{Named list with taxon information, e.g.
\code{list(scientificName = "Ardea", taxonRank = "genus", vernacularname.eng = "great herons")}.}
}
\value{
\code{x} with updated taxon information.
}
\description{
Updates taxonomic information in data and metadata for a provided taxon.
This allows to:
\enumerate{
\item Update a taxon: provide the same name in \code{to} and \code{from$scientificName}.
\item Replace a taxon: provide a new name in \code{from$scientificName}.
\item Lump a taxon: provide a name in \code{from$scientificName} that is already
present in the dataset.
In all cases, existing information will be overwritten with the provided
information.
}
}
\examples{
x <- example_dataset()

# Update taxonomic information for "Anas platyrhynchos"
updated_x <- update_taxon(
  x,
  from = "Anas platyrhynchos",
  to = list (
    scientificName = "Anas platyrhynchos",
    taxonID = "https://www.checklistbank.org/dataset/COL2023/taxon/DGP6",
    taxonRank = "species",
    vernacularNames.fra = "canard colvert"
  )
)

# Lump "Ardea cinerea" into already present "Ardea", using the provided info
updated_x <- update_taxon(
  x,
  from = "Ardea cinerea",
  to = list(scientificName = "Ardea", vernacularname.fra = "grands hérons")
)
}
\seealso{
Other transformation functions: 
\code{\link{merge_camtrapdp}()},
\code{\link{round_coordinates}()},
\code{\link{shift_time}()},
\code{\link{write_dwc}()},
\code{\link{write_eml}()}
}
\concept{transformation functions}
