% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candiscList.R
\name{candiscList}
\alias{candiscList}
\alias{candiscList.mlm}
\alias{plot.candiscList}
\alias{print.candiscList}
\alias{summary.candiscList}
\title{Canonical discriminant analyses}
\usage{
candiscList(mod, ...)

\method{candiscList}{mlm}(mod, type = "2", manova, ndim, ...)

\method{print}{candiscList}(x, ...)

\method{summary}{candiscList}(object, ...)

\method{plot}{candiscList}(x, term, ask = interactive(), graphics = TRUE, ...)
}
\arguments{
\item{mod}{An mlm object, such as computed by lm() with a multivariate
response}

\item{\dots}{arguments to be passed down.}

\item{type}{type of test for the model \code{term}, one of: "II", "III",
"2", or "3"}

\item{manova}{the \code{Anova.mlm} object corresponding to \code{mod}.
Normally, this is computed internally by \code{Anova(mod)}}

\item{ndim}{Number of dimensions to store in the \code{means},
\code{structure}, \code{scores} and \verb{coeffs.*} components.
The default is the rank of the H matrix for the hypothesis term.}

\item{object, x}{A candiscList object}

\item{term}{The name of one term to be plotted for the \code{plot} method.
If not specified, one candisc plot is produced for each term in the
\code{mlm} object.}

\item{ask}{If \code{TRUE} (the default, when running interactively), a menu
of terms is presented; if ask is FALSE, canonical plots for all terms are
produced.}

\item{graphics}{if \code{TRUE} (the default, when running interactively),
then the menu of terms to plot is presented in a dialog box rather than as a
text menu.}
}
\value{
An object of class \code{candiscList} which is a list of
\code{"candisc"} objects for the terms in the mlm.
}
\description{
\code{candiscList} performs a generalized canonical discriminant analysis
for all terms in a multivariate linear model (i.e., an \code{mlm} object),
computing canonical scores and vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{candiscList(mlm)}: \code{"mlm"} method.

}}
\section{Methods (by generic)}{
\itemize{
\item \code{print(candiscList)}: \code{print()} method for \code{"candiscList"} objects.

\item \code{summary(candiscList)}: \code{summary()} method for \code{"candiscList"} objects.

\item \code{plot(candiscList)}: \code{plot()} method for \code{"candiscList"} objects.

}}
\examples{

grass.mod <- lm(cbind(N1,N9,N27,N81,N243) ~ Block + Species, data=Grass)

grass.canL <-candiscList(grass.mod)
names(grass.canL)
names(grass.canL$Species)

\dontrun{
print(grass.canL)
}
plot(grass.canL, type="n", ask=FALSE)
heplot(grass.canL$Species, scale=6)
heplot(grass.canL$Block, scale=2)


}
\seealso{
\code{\link[=candisc]{candisc()}}, \code{\link[heplots:heplot]{heplots::heplot()}}, \code{\link[heplots:heplot3d]{heplots::heplot3d()}}
}
\author{
Michael Friendly and John Fox
}
\keyword{hplot}
\keyword{multivariate}
