# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/color/uk_UA/__init__.py

#' @title ColorProvider Ukrainian (Ukraine)
#' @inherit ColorProvider description details return
#' @export
#' @family uk
#' @family UA
#' @examples
#' x <- ColorProvider_uk_UA$new()
#' x$locale
#' x$color_name()
#' x$safe_color_name()
#' x$hex_color()
#' x$safe_hex_color()
#' x$rgb_color()
#' x$rgb_css_color()
ColorProvider_uk_UA <- R6::R6Class(
  inherit = ColorProvider,
  "ColorProvider_uk_UA",
  lock_objects = FALSE,
  private = list(
    # A vector with named list items containing the name of the color and the hex value.
    all_colors_ = list(
      "\u0410\u0431\u0440\u0438\u043a\u043e\u0441\u043e\u0432\u0438\u0439" = "#FBCEB1",
      "\u0410\u043a\u0432\u0430\u043c\u0430\u0440\u0438\u043d\u043e\u0432\u0438\u0439" = "#7FFFD4",
      "\u0410\u043b\u0456\u0437\u0430\u0440\u0438\u043d\u043e\u0432\u0438\u0439 \u0447\u0435\u0440\u0432\u043e\u043d\u0438\u0439" = "#E32636",
      "\u0410\u043c\u0430\u0440\u0430\u043d\u0442\u043e\u0432\u0438\u0439" = "#E52B50",
      "\u0410\u043c\u0430\u0440\u0430\u043d\u0442\u043e\u0432\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#F19CBB",
      "\u0410\u043c\u0435\u0442\u0438\u0441\u0442\u043e\u0432\u0438\u0439" = "#9966CC",
      "\u0410\u043d\u0434\u0440\u043e\u0457\u0434\u043d\u0438\u0439 \u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#A4C639",
      "\u0410\u0440\u0441\u0435\u043d\u043e\u0432\u0438\u0439" = "#3B444B",
      "\u0410\u0442\u043e\u043c\u043d\u0438\u0439 \u043c\u0430\u043d\u0434\u0430\u0440\u0456\u043d\u043e\u0432\u0438\u0439" = "#FF9966",
      "\u0411\u0430\u0433\u0440\u044f\u043d\u0438\u0439" = "#FF2400",
      "\u0411\u0430\u043a\u043b\u0430\u0436\u0430\u043d\u043e\u0432\u0438\u0439" = "#990066",
      "\u0411\u0430\u0440\u0432\u0456\u043d\u043a\u043e\u0432\u0438\u0439" = "#CCCCFF",
      "\u0411\u0435\u0436\u0435\u0432\u0438\u0439" = "#F5F5DC",
      "\u0411\u0435\u0440\u043b\u0456\u043d\u0441\u044c\u043a\u0430 \u043b\u0430\u0437\u0443\u0440" = "#003153",
      "\u0411\u043b\u0430\u0432\u0430\u0442\u043d\u0438\u0439" = "#6495ED",
      "\u0411\u043b\u0430\u043a\u0438\u0442\u043d\u0438\u0439" = "#AFEEEE",
      "\u0411\u043b\u0430\u043a\u0438\u0442\u043d\u0438\u0439 \u0411\u0440\u0430\u043d\u0434\u0435\u0439\u0441\u0430" = "#0070FF",
      "\u0411\u043b\u0430\u043a\u0438\u0442\u043d\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#00DDDD",
      "\u0411\u043b\u0430\u043a\u0438\u0442\u043d\u043e-\u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u0438\u0439" = "#8A2BE2",
      "\u0411\u043b\u0456\u0434\u0438\u0439 \u0440\u043e\u0436\u0435\u0432\u043e-\u043b\u0456\u043b\u043e\u0432\u0438\u0439" = "#996666",
      "\u0411\u043b\u0456\u0434\u043e-\u0431\u0440\u0443\u043d\u0430\u0442\u043d\u0438\u0439" = "#987654",
      "\u0411\u043b\u0456\u0434\u043e-\u0432\u043e\u043b\u043e\u0448\u043a\u043e\u0432\u0438\u0439" = "#ABCDEF",
      "\u0411\u043b\u0456\u0434\u043e-\u043a\u0430\u0440\u043c\u0456\u043d\u043e\u0432\u0438\u0439" = "#AF4035",
      "\u0411\u043b\u0456\u0434\u043e-\u043a\u0430\u0448\u0442\u0430\u043d\u043e\u0432\u0438\u0439" = "#DDADAF",
      "\u0411\u043b\u0456\u0434\u043e-\u043f\u0443\u0440\u043f\u0443\u0440\u043e\u0432\u0438\u0439" = "#F984E5",
      "\u0411\u043b\u0456\u0434\u043e-\u043f\u0456\u0441\u043e\u0447\u043d\u0438\u0439" = "#DABDAB",
      "\u0411\u043b\u0456\u0434\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FADADD",
      "\u0411\u043e\u043b\u043e\u0442\u043d\u0438\u0439" = "#ACB78E",
      "\u0411\u0440\u043e\u043d\u0437\u043e\u0432\u0438\u0439" = "#CD7F32",
      "\u0411\u0440\u0443\u043d\u0430\u0442\u043d\u0438\u0439" = "#964B00",
      "\u0411\u0440\u0443\u043d\u0430\u0442\u043e-\u043c\u0430\u043b\u0438\u043d\u043e\u0432\u0438\u0439" = "#800000",
      "\u0411\u0443\u0434\u044f\u043a\u043e\u0432\u0438\u0439" = "#D8BFD8",
      "\u0411\u0443\u0437\u043a\u043e\u0432\u0438\u0439" = "#C8A2C8",
      "\u0411\u0443\u0440\u0433\u0443\u043d\u0434\u0441\u044c\u043a\u0438\u0439" = "#900020",
      "\u0411\u0443\u0440\u0438\u0439" = "#755A57", "\u0411\u0443\u0440\u0448\u0442\u0438\u043d\u043e\u0432\u0438\u0439" = "#FFBF00",
      "\u0411\u0456\u043b\u0438\u0439" = "#FFFFFF", "\u0411\u0456\u043b\u0438\u0439 \u043d\u0430\u0432\u0430\u0445\u043e" = "#FFDEAD",
      "\u0411\u0456\u0440\u044e\u0437\u043e\u0432\u0438\u0439" = "#30D5C8",
      "\u0411\u0456\u0441\u0442\u0440" = "#3D2B1F", "\u0412\u043e\u0434\u0430 \u043f\u043b\u044f\u0436\u0430 \u0411\u043e\u043d\u0434\u0456" = "#0095B6",
      "\u0412\u043e\u0445\u0440\u0430" = "#CC7722", "\u0412\u0456\u0434\u0431\u0456\u0440\u043d\u0438\u0439 \u0436\u043e\u0432\u0442\u0438\u0439" = "#FFBA00",
      "\u0412\u0456\u0437\u0430\u043d\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0439" = "#702963",
      "\u0413\u0430\u0440\u0431\u0443\u0437" = "#FF7518", "\u0413\u0430\u0440\u044f\u0447\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FC0FC0",
      "\u0413\u0435\u043b\u0456\u043e\u0442\u0440\u043e\u043f" = "#DF73FF",
      "\u0413\u043b\u0438\u0431\u043e\u043a\u0438\u0439 \u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u0438\u0439" = "#423189",
      "\u0413\u043b\u0438\u0446\u0456\u043d\u0456\u044f" = "#C9A0DC",
      "\u0413\u0440\u0443\u0448\u0435\u0432\u0438\u0439" = "#D1E231",
      "\u0413\u0443\u043c\u0456\u0433\u0443\u0442" = "#E49B0F",
      "\u0413\u0456\u0440\u0447\u0438\u0447\u043d\u0438\u0439" = "#FFDB58",
      "\u0414\u0435\u0440\u0435\u0432\u0430" = "#79443B", "\u0414\u0436\u0438\u043d\u0441\u043e\u0432\u0438\u0439" = "#1560BD",
      "\u0414\u0456\u0430\u043c\u0430\u043d\u0442\u043e\u0432\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FF55A3",
      "\u0416\u043e\u0432\u0442\u0438\u0439" = "#FFFF00", "\u0416\u043e\u0432\u0442\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#ADFF2F",
      "\u0416\u043e\u0432\u0442\u043e-\u043f\u0435\u0440\u0441\u0438\u043a\u043e\u0432\u0438\u0439" = "#FADFAD",
      "\u0417\u0430\u0445\u0438\u0441\u043d\u0438\u0439 \u0441\u0438\u043d\u0456\u0439" = "#1E90FF",
      "\u0417\u0435\u043b\u0435\u043d\u0430 \u0432\u0435\u0441\u043d\u0430" = "#00FF7F",
      "\u0417\u0435\u043b\u0435\u043d\u0430 \u043c\u02bc\u044f\u0442\u0430" = "#98FF98",
      "\u0417\u0435\u043b\u0435\u043d\u0430 \u0441\u043e\u0441\u043d\u0430" = "#01796F",
      "\u0417\u0435\u043b\u0435\u043d\u0435 \u043c\u043e\u0440\u0435" = "#2E8B57",
      "\u0417\u0435\u043b\u0435\u043d\u0438\u0439" = "#00FF00",
      "\u0417\u0435\u043b\u0435\u043d\u0438\u0439 \u0430\u0440\u043c\u0456\u0439\u0441\u044c\u043a\u0438\u0439" = "#4B5320",
      "\u0417\u0435\u043b\u0435\u043d\u0438\u0439 \u043c\u043e\u0445" = "#ADDFAD",
      "\u0417\u0435\u043b\u0435\u043d\u0438\u0439 \u043f\u0430\u043f\u043e\u0440\u043e\u0442\u044c" = "#4F7942",
      "\u0417\u0435\u043b\u0435\u043d\u0438\u0439 \u0447\u0430\u0439" = "#D0F0C0",
      "\u0417\u0435\u043b\u0435\u043d\u043e-\u0441\u0456\u0440\u0438\u0439 \u0447\u0430\u0439" = "#CADABA",
      "\u0417\u0435\u043b\u0435\u043d\u0443\u0432\u0430\u0442\u043e-\u0431\u043b\u0430\u043a\u0438\u0442\u043d\u0438\u0439" = "#008080",
      "\u0417\u043e\u043b\u043e\u0442\u0430\u0432\u043e-\u0431\u0435\u0440\u0435\u0437\u043e\u0432\u0438\u0439" = "#DAA520",
      "\u0417\u043e\u043b\u043e\u0442\u0438\u0439" = "#FFD700",
      "\u0417\u043e\u043b\u043e\u0442\u0438\u0441\u0442\u043e-\u043a\u0430\u0448\u0442\u0430\u043d\u043e\u0432\u0438\u0439" = "#6D351A",
      "\u0406\u043d\u0434\u0438\u0433\u043e" = "#4B0082", "\u0406\u0440\u0436\u0430\u0432\u0438\u0439" = "#B7410E",
      "\u041a\u0430\u0440\u0434\u0438\u043d\u0430\u043b (\u043a\u043e\u043b\u0456\u0440)" = "#C41E3A",
      "\u041a\u0430\u0440\u043c\u0456\u043d\u043e\u0432\u0438\u0439" = "#960018",
      "\u041a\u0430\u0448\u0442\u0430\u043d\u043e\u0432\u0438\u0439" = "#CD5C5C",
      "\u041a\u043e\u0431\u0430\u043b\u044c\u0442\u043e\u0432\u0438\u0439" = "#0047AB",
      "\u041a\u043e\u043b\u0456\u0440 \u0436\u043e\u0432\u0442\u043e\u0433\u043e \u0448\u043a\u0456\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0431\u0443\u0441\u0430" = "#FFD800",
      "\u041a\u043e\u043b\u0456\u0440 \u0437\u0430\u0441\u043c\u0430\u0433\u0438" = "#D2B48C",
      "\u041a\u043e\u043b\u0456\u0440 \u043c\u043e\u0440\u0441\u044c\u043a\u043e\u0457 \u043f\u0456\u043d\u0438" = "#FFF5EE",
      "\u041a\u043e\u043b\u0456\u0440 \u043c\u043e\u0440\u0441\u044c\u043a\u043e\u0457 \u0445\u0432\u0438\u043b\u0456" = "#00FFFF",
      "\u041a\u043e\u0440\u0430\u043b\u043e\u0432\u0438\u0439" = "#FF7F50",
      "\u041a\u043e\u0440\u043e\u043b\u0456\u0432\u0441\u044c\u043a\u0438\u0439 \u0441\u0438\u043d\u0456\u0439" = "#4169E1",
      "\u041a\u0440\u0435\u043c\u043e\u0432\u0438\u0439" = "#FFFDD0",
      "\u041a\u0443\u043a\u0443\u0440\u0443\u0434\u0437\u044f\u043d\u0438\u0439" = "#FBEC5D",
      "\u041a\u0456\u043d\u043e\u0432\u0430\u0440" = "#FF4D00",
      "\u041b\u0430\u0432\u0430\u043d\u0434\u043d\u0438\u0439" = "#E6E6FA",
      "\u041b\u0430\u0437\u0443\u0440\u043e\u0432\u0438\u0439" = "#007BA7",
      "\u041b\u0430\u0437\u0443\u0440\u043e\u0432\u043e-\u0441\u0438\u043d\u0456\u0439" = "#2A52BE",
      "\u041b\u0430\u0439\u043c" = "#CCFF00", "\u041b\u0430\u0442\u0443\u043d\u043d\u0438\u0439" = "#B5A642",
      "\u041b\u0438\u043c\u043e\u043d\u043d\u0438\u0439" = "#FDE910",
      "\u041b\u0438\u043c\u043e\u043d\u043d\u043e-\u043a\u0440\u0435\u043c\u043e\u0432\u0438\u0439" = "#FFFACD",
      "\u041b\u043b\u044f\u043d\u0438\u0439" = "#EEDC82", "\u041b\u043e\u0441\u043e\u0441\u0435\u0432\u0438\u0439" = "#FF8C69",
      "\u041b\u0456\u043b\u043e\u0432\u0438\u0439" = "#DB7093",
      "\u041c\u0430\u043b\u0430\u0445\u0456\u0442\u043e\u0432\u0438\u0439" = "#0BDA51",
      "\u041c\u0430\u043b\u0438\u043d\u043e\u0432\u0438\u0439" = "#DC143C",
      "\u041c\u0430\u043d\u0434\u0430\u0440\u0438\u043d\u043e\u0432\u0438\u0439" = "#FFCC00",
      "\u041c\u0438\u0441\u043b\u0438\u0432\u0441\u044c\u043a\u0438\u0439" = "#004225",
      "\u041c\u043e\u0440\u043a\u0432\u044f\u043d\u0438\u0439" = "#ED9121",
      "\u041c\u0456\u0434\u043d\u0438\u0439" = "#B87333", "\u041c\u0456\u0436\u043d\u0430\u0440\u043e\u0434\u043d\u0438\u0439 \u043f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u0438\u0439" = "#FF4F00",
      "\u041d\u0435\u0444\u0440\u0438\u0442\u043e\u0432\u0438\u0439" = "#00A86B",
      "\u041d\u0456\u0436\u043d\u043e-\u0431\u043b\u0430\u043a\u0438\u0442\u043d\u0438\u0439" = "#E0FFFF",
      "\u041d\u0456\u0436\u043d\u043e-\u043e\u043b\u0438\u0432\u043a\u043e\u0432\u0438\u0439" = "#6B8E23",
      "\u041d\u0456\u0436\u043d\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FB607F",
      "\u041e\u043b\u0438\u0432\u043a\u043e\u0432\u0438\u0439" = "#808000",
      "\u041e\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e-\u0441\u0438\u043d\u0456\u0439" = "#003366",
      "\u041e\u0440\u0445\u0456\u0434\u0435\u044f" = "#DA70D6",
      "\u041f\u0430\u043b\u0435\u043d\u0430 \u0441\u0456\u0435\u043d\u0430" = "#E97451",
      "\u041f\u0430\u043b\u0435\u043d\u0438\u0439 \u043e\u0440\u0430\u043d\u0436\u0435\u0432\u0438\u0439" = "#CC5500",
      "\u041f\u0430\u043d\u0433" = "#C7FCEC", "\u041f\u0430\u0440\u043e\u0441\u0442\u043e\u043a \u043f\u0430\u043f\u0430\u0457" = "#FFEFD5",
      "\u041f\u0430\u0441\u0442\u0435\u043b\u044c\u043d\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#77DD77",
      "\u041f\u0430\u0441\u0442\u0435\u043b\u044c\u043d\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FFD1DC",
      "\u041f\u0435\u0440\u0441\u0438\u043a\u043e\u0432\u0438\u0439" = "#FFE5B4",
      "\u041f\u0435\u0440\u0441\u044c\u043a\u0438\u0439 \u0441\u0438\u043d\u0456\u0439" = "#6600FF",
      "\u041f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u0438\u0439" = "#FFA500",
      "\u041f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u043e-\u043f\u0435\u0440\u0441\u0438\u043a\u043e\u0432\u0438\u0439" = "#FFCC99",
      "\u041f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FF9966",
      "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u0438\u0439" = "#FF00FF",
      "\u041f\u0443\u0440\u043f\u0443\u0440\u043e\u0432\u0438\u0439" = "#660099",
      "\u041f\u0448\u0435\u043d\u0438\u0447\u043d\u0438\u0439" = "#F5DEB3",
      "\u041f\u0456\u0441\u043e\u0447\u043d\u0438\u0439 \u043a\u043e\u043b\u0456\u0440" = "#F4A460",
      "\u0420\u043e\u0436\u0435\u0432\u0438\u0439" = "#FFC0CB",
      "\u0420\u043e\u0436\u0435\u0432\u0438\u0439 \u041c\u0430\u0443\u043d\u0442\u0431\u0435\u0442\u0442\u0435\u043d\u0430" = "#997A8D",
      "\u0420\u043e\u0436\u0435\u0432\u043e-\u043b\u0430\u0432\u0430\u043d\u0434\u043d\u0438\u0439" = "#FFF0F5",
      "\u0420\u043e\u0436\u0435\u0432\u043e-\u043b\u0456\u043b\u043e\u0432\u0438\u0439" = "#993366",
      "\u0421\u0430\u043b\u0430\u0442\u043e\u0432\u0438\u0439" = "#7FFF00",
      "\u0421\u0430\u043d\u0433\u0440\u0456\u044f" = "#92000A",
      "\u0421\u0430\u043f\u0444\u0456\u0440\u043e\u0432\u0438\u0439" = "#082567",
      "\u0421\u0432\u0456\u0442\u043b\u043e-\u0441\u0438\u043d\u0456\u0439" = "#007DFF",
      "\u0421\u0435\u043f\u0456\u044f" = "#704214", "\u0421\u0438\u0432\u0430\u0432\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#ACE1AF",
      "\u0421\u0438\u0433\u043d\u0430\u043b\u044c\u043d\u043e-\u043f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u0438\u0439" = "#FF9900",
      "\u0421\u0438\u043d\u044f \u043f\u0438\u043b" = "#003399",
      "\u0421\u0438\u043d\u044f \u0441\u0442\u0430\u043b\u044c" = "#4682B4",
      "\u0421\u0438\u043d\u0456 \u044f\u0439\u0446\u044f \u043c\u0430\u043b\u0438\u043d\u0456\u0432\u043a\u0438" = "#00CCCC",
      "\u0421\u0438\u043d\u0456\u0439" = "#0000FF", "\u0421\u0438\u043d\u0456\u0439 (RYB)" = "#0247FE",
      "\u0421\u0438\u043d\u0456\u0439 (\u043f\u0456\u0433\u043c\u0435\u043d\u0442)" = "#333399",
      "\u0421\u0438\u043d\u0456\u0439 \u0412\u041f\u0421" = "#5D8AA8",
      "\u0421\u0438\u043d\u0456\u0439 \u041a\u043b\u0435\u0439\u043d\u0430" = "#3A75C4",
      "\u0421\u043b\u0438\u0432\u043e\u0432\u0438\u0439" = "#660066",
      "\u0421\u043c\u0430\u0440\u0430\u0433\u0434\u043e\u0432\u0438\u0439" = "#50C878",
      "\u0421\u043f\u0430\u0440\u0436\u0435\u0432\u0438\u0439" = "#7BA05B",
      "\u0421\u0440\u0456\u0431\u043d\u0438\u0439" = "#C0C0C0",
      "\u0421\u0442\u0430\u0440\u0435 \u0437\u043e\u043b\u043e\u0442\u043e" = "#CFB53B",
      "\u0421\u0456\u0440\u0430 \u0441\u043f\u0430\u0440\u0436\u0430" = "#465945",
      "\u0421\u0456\u0440\u0438\u0439" = "#808080", "\u0421\u0456\u0440\u0438\u0439 \u0448\u0438\u0444\u0435\u0440" = "#708090",
      "\u0422\u0435\u043c\u043d\u0438\u0439 \u0432\u0435\u0441\u043d\u044f\u043d\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#177245",
      "\u0422\u0435\u043c\u043d\u0438\u0439 \u0436\u043e\u0432\u0442\u043e-\u0431\u0440\u0443\u043d\u0430\u0442\u043d\u0438\u0439" = "#918151",
      "\u0422\u0435\u043c\u043d\u0438\u0439 \u0437\u0435\u043b\u0435\u043d\u0438\u0439 \u0447\u0430\u0439" = "#BADBAD",
      "\u0422\u0435\u043c\u043d\u0438\u0439 \u043f\u0430\u0441\u0442\u0435\u043b\u044c\u043d\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#03C03C",
      "\u0422\u0435\u043c\u043d\u0438\u0439 \u0445\u0430\u043a\u0456" = "#BDB76B",
      "\u0422\u0435\u043c\u043d\u0438\u0439 \u0456\u043d\u0434\u0438\u0433\u043e" = "#310062",
      "\u0422\u0435\u043c\u043d\u043e-\u0430\u0441\u043f\u0456\u0434\u043d\u0438\u0439 \u0441\u0456\u0440\u0438\u0439" = "#2F4F4F",
      "\u0422\u0435\u043c\u043d\u043e-\u0431\u0440\u0443\u043d\u0430\u0442\u043d\u0438\u0439" = "#654321",
      "\u0422\u0435\u043c\u043d\u043e-\u0431\u0456\u0440\u044e\u0437\u043e\u0432\u0438\u0439" = "#116062",
      "\u0422\u0435\u043c\u043d\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#013220",
      "\u0422\u0435\u043c\u043d\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439 \u0445\u0430\u043a\u0456" = "#78866B",
      "\u0422\u0435\u043c\u043d\u043e-\u0437\u043e\u043b\u043e\u0442\u0438\u0439" = "#B8860B",
      "\u0422\u0435\u043c\u043d\u043e-\u043a\u0430\u0440\u043c\u0456\u043d\u043e\u0432\u0438\u0439" = "#560319",
      "\u0422\u0435\u043c\u043d\u043e-\u043a\u0430\u0448\u0442\u0430\u043d\u043e\u0432\u0438\u0439" = "#986960",
      "\u0422\u0435\u043c\u043d\u043e-\u043a\u043e\u0440\u0430\u043b\u043e\u0432\u0438\u0439" = "#CD5B45",
      "\u0422\u0435\u043c\u043d\u043e-\u043b\u0430\u0437\u0443\u0440\u043d\u0438\u0439" = "#08457E",
      "\u0422\u0435\u043c\u043d\u043e-\u043b\u043e\u0441\u043e\u0441\u0435\u0432\u0438\u0439" = "#E9967A",
      "\u0422\u0435\u043c\u043d\u043e-\u043c\u0430\u043d\u0434\u0430\u0440\u0438\u043d\u043e\u0432\u0438\u0439" = "#FFA812",
      "\u0422\u0435\u043c\u043d\u043e-\u043e\u043b\u0438\u0432\u043a\u043e\u0432\u0438\u0439" = "#556832",
      "\u0422\u0435\u043c\u043d\u043e-\u043f\u0435\u0440\u0441\u0438\u043a\u043e\u0432\u0438\u0439" = "#FFDAB9",
      "\u0422\u0435\u043c\u043d\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#E75480",
      "\u0422\u0435\u043c\u043d\u043e-\u0441\u0438\u043d\u0456\u0439" = "#000080",
      "\u0423\u043b\u044c\u0442\u0440\u0430\u043c\u0430\u0440\u0438\u043d\u043e\u0432\u0438\u0439" = "#120A8F",
      "\u0423\u043c\u0431\u0440\u0430" = "#734A12", "\u0423\u043c\u0431\u0440\u0430 \u043f\u0430\u043b\u0435\u043d\u0430" = "#8A3324",
      "\u0424\u0443\u043a\u0441\u0456\u044f" = "#FF00FF", "\u0424\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u0438\u0439" = "#8B00FF",
      "\u0424\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u043e-\u0431\u0430\u043a\u043b\u0430\u0436\u0430\u043d\u043e\u0432\u0438\u0439" = "#991199",
      "\u0424\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u043e-\u0447\u0435\u0440\u0432\u043e\u043d\u0438\u0439" = "#C71585",
      "\u0425\u0430\u043a\u0456" = "#C3B091", "\u0426\u0438\u043d\u0430\u043c\u043e\u043d\u043e\u0432\u0438\u0439" = "#7B3F00",
      "\u0426\u0438\u043d\u043d\u0432\u0430\u043b\u044c\u0434\u0438\u0442" = "#EBC2AF",
      "\u0426\u0456\u0430\u043d (\u043a\u043e\u043b\u0456\u0440)" = "#00FFFF",
      "\u0426\u0456\u0430\u043d\u043e-\u0431\u043b\u0430\u043a\u0438\u0442\u043d\u0438\u0439" = "#F0F8FF",
      "\u0427\u0435\u0440\u0432\u043e\u043d\u0438\u0439" = "#FF0000",
      "\u0427\u0435\u0440\u0432\u043e\u043d\u043e-\u0431\u0443\u0440\u043e-\u043f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u0438\u0439" = "#CD5700",
      "\u0427\u0435\u0440\u0432\u043e\u043d\u043e\u0432\u0430\u0442\u043e-\u0431\u0440\u0443\u043d\u0430\u0442\u043d\u0438\u0439" = "#CC8899",
      "\u0427\u043e\u0440\u043d\u0438\u0439" = "#000000", "\u0428\u0430\u0444\u0440\u0430\u043d\u043e\u0432\u0438\u0439" = "#F4C430",
      "\u0428\u043a\u0456\u0440\u0430 \u0431\u0443\u0439\u0432\u043e\u043b\u0430" = "#F0DC82",
      "\u0428\u043e\u043a\u043e\u043b\u0430\u0434\u043d\u0438\u0439" = "#D2691E",
      "\u042f\u0441\u043a\u0440\u0430\u0432\u043e-\u0431\u0443\u0440\u0448\u0442\u0438\u043d\u043e\u0432\u0438\u0439" = "#FF7E00",
      "\u042f\u0441\u043a\u0440\u0430\u0432\u043e-\u0431\u0456\u0440\u044e\u0437\u043e\u0432\u0438\u0439" = "#08E8DE",
      "\u042f\u0441\u043a\u0440\u0430\u0432\u043e-\u0437\u0435\u043b\u0435\u043d\u0438\u0439" = "#66FF00",
      "\u042f\u0441\u043a\u0440\u0430\u0432\u043e-\u0440\u043e\u0436\u0435\u0432\u0438\u0439" = "#FF007F",
      "\u042f\u0441\u043a\u0440\u0430\u0432\u043e-\u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u0438\u0439" = "#CD00CD",
      "\u042f\u0441\u043d\u043e-\u0431\u0440\u0443\u043d\u0430\u0442\u043d\u0438\u0439" = "#CD853F",
      "\u042f\u0441\u043d\u043e-\u0432\u0438\u0448\u043d\u0435\u0432\u0438\u0439" = "#DE3163",
      "\u042f\u0441\u043d\u043e-\u043b\u0430\u0437\u0443\u0440\u043e\u0432\u0438\u0439" = "#007FFF",
      "\u042f\u0441\u043d\u043e-\u043b\u0430\u0437\u0443\u0440\u043e\u0432\u0438\u0439 (\u0432\u0435\u0431)" = "#F0FFFF"
    ),
    # safe to use colors.
    safe_colors_ = c(
      "\u0427\u043e\u0440\u043d\u0438\u0439",
      "\u0411\u0440\u0443\u043d\u0430\u0442\u043e-\u043c\u0430\u043b\u0438\u043d\u043e\u0432\u0438\u0439",
      "\u041a\u043e\u043b\u0456\u0440 \u043c\u043e\u0440\u0441\u044c\u043a\u043e\u0457 \u0445\u0432\u0438\u043b\u0456",
      "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u0438\u0439",
      "\u0426\u0456\u0430\u043d (\u043a\u043e\u043b\u0456\u0440)",
      "\u0421\u0440\u0456\u0431\u043d\u0438\u0439",
      "\u0417\u0435\u043b\u0435\u043d\u0438\u0439",
      "\u0422\u0435\u043c\u043d\u043e-\u0441\u0438\u043d\u0456\u0439",
      "\u041e\u043b\u0438\u0432\u043a\u043e\u0432\u0438\u0439",
      "\u041f\u043e\u043c\u0430\u0440\u0430\u043d\u0447\u0435\u0432\u0438\u0439",
      "\u0421\u0438\u043d\u0456\u0439",
      "\u0427\u0435\u0440\u0432\u043e\u043d\u0438\u0439",
      "\u0421\u0456\u0440\u0438\u0439",
      "\u0416\u043e\u0432\u0442\u0438\u0439",
      "\u0411\u0456\u043b\u0438\u0439"
    ),
    locale_ = "uk_UA"
  )
)
