% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sset.R
\name{sset}
\alias{sset}
\title{Cheaper subset \code{sset()}}
\usage{
sset(x, i = NULL, j = NULL, ...)
}
\arguments{
\item{x}{Vector or data frame.}

\item{i}{A logical vector or integer vector of locations.}

\item{j}{Column indices, names or logical vector.}

\item{...}{Further parameters passed to \code{[}.}
}
\value{
A new vector, data frame, list, matrix or other R object.
}
\description{
\code{sset()} is a cheaper alternative to \code{[}.

It consistently subsets data frame rows for any data frame class including
tibble and data.table.
}
\details{
\subsection{S3 dispatching}{

\code{sset} will internally dispatch the correct method and
will call \code{[} if it can't find an appropriate method. This means
one can define their own \code{[} method for custom S3 objects.

To speed up subsetting for common objects likes Dates and \code{POSIXlt}
an internal generic function is used which overwrites the \code{[} method for
that common object. This is why subsetting \code{POSIXlt} is much faster with
\code{sset} an internal method has been defined. For more details see the code
for \code{cheapr:::cheapr_sset}.
}

\subsection{Difference to base R}{

When \code{i} is a logical vector, it is passed directly to \code{which_()}. \cr
This means that \code{NA} values are ignored and this also means that \code{i}
is not recycled, so it is good practice to make sure the logical vector
matches the length of x. To return \code{NA} values, use \code{sset(x, NA_integer_)}.
}

\subsection{ALTREP range subsetting}{

When \code{i} is an ALTREP compact sequence which can be commonly created
using e.g. \code{1:10} or using \code{seq_len}, \code{seq_along} and \code{seq.int},
\code{sset} internally uses a range-based subsetting method
which is faster and doesn't allocate \code{i} into memory.
}
}
\examples{
library(cheapr)
library(bench)

# Selecting columns
sset(airquality, j = "Temp")
sset(airquality, j = 1:2)

# Selecting rows
sset(iris, 1:5)

# Rows and columns
sset(iris, 1:5, 1:5)
sset(iris, iris$Sepal.Length > 7, c("Species", "Sepal.Length"))

# Comparison against base
x <- rnorm(10^4)

mark(x[1:10^3], sset(x, 1:10^3))
mark(x[x > 0], sset(x, x > 0))

df <- data.frame(x = x)

mark(df[df$x > 0, , drop = FALSE],
     sset(df, df$x > 0),
     check = FALSE) # Row names are different

}
