% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parc_utils.R
\name{parc_add_subcortex}
\alias{parc_add_subcortex}
\title{Add subcortex to cortical parcellation}
\usage{
parc_add_subcortex(parc, parc_sub = "MNI")
}
\arguments{
\item{parc}{A single-column "dlabel" \code{"xifti"} object without
subcortical data.}

\item{parc_sub}{A single-column \code{"xifti"} object with only
subcortical data. Or, \code{"MNI"} (default) to read in and use the MNI
subcortex included in \code{ciftiTools}. (The Connectome Workbench is
required.)}
}
\value{
The new parcellation with added subcortical data and labels.
}
\description{
Add the subcortex, with each brain structure as a separate parcel, to
a "dlabel" cortical parcellation.
}
\seealso{
Other parcellation-related: 
\code{\link{apply_parc}()},
\code{\link{load_parc}()},
\code{\link{load_sub_parc}()},
\code{\link{parc_borders}()},
\code{\link{parc_vals_to_xifti}()}
}
\concept{parcellation-related}
