% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_get_data.R
\name{cs_get_data}
\alias{cs_get_data}
\title{Get Data From A cs_analysis Object}
\usage{
cs_get_data(x, dataset = "data")
}
\arguments{
\item{x}{A cs_analysis object.}

\item{dataset}{The dataset you wish to retrieve. Available options are
\itemize{
\item \code{"original"} (the raw original dataset)
\item \code{"wide"} (the original dataset in wide format)
\item \code{"data"} (the dataset which is used in the calculations).
The default is \code{"data"}
}}
}
\value{
A tibble
}
\description{
Get Data From A cs_analysis Object
}
\examples{
cs_results <- claus_2020 |>
  cs_anchor(id, time, bdi, mid_improvement = 9, pre = 1, post = 4)

cs_get_data(cs_results)
cs_get_data(cs_results, dataset = "wide")
cs_get_data(cs_results, dataset = "original")
}
\seealso{
Extractor functions
\code{\link{cs_get_augmented_data}()},
\code{\link{cs_get_model}()},
\code{\link{cs_get_n}()},
\code{\link{cs_get_reliability}()},
\code{\link{cs_get_summary}()}
}
\concept{get}
