% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_env_dir.R
\name{get_env_dir}
\alias{get_env_dir}
\title{Retrieve Path To Environment}
\usage{
get_env_dir(env_name = "condathis-env")
}
\arguments{
\item{env_name}{Character. Name of the Conda environment where the packages
are going to be installed. Defaults to 'condathis-env'.}
}
\value{
A character string indicating the path where environments will be created.
}
\description{
Retrieve path to where environment should be created.
\strong{Note}: It retrieves the Path even if the environment is \strong{not} created yet.
}
\examples{
condathis::with_sandbox_dir({
  # Get the default environment directory
  condathis::get_env_dir()
  #> "/path/to/condathis/envs/condathis-env"

  # Get the directory for a specific environment
  condathis::get_env_dir("my-env")
  #> "/path/to/condathis/envs/my-env"
})

}
