% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-DequeR6.R
\name{Deque}
\alias{Deque}
\title{Deque Class}
\description{
Deques are a generalization of stacks and queues typically
with methods to add, delete and access elements at both sides of the
underlying data sequence. As such, the \link{Deque} can also be used to mimic
both stacks and queues. For the standard S3 interface, see \code{\link[=deque]{deque()}}.
}
\details{
This class inherits from class \code{\link[=Container]{Container()}} and extends it by
\code{popleft} and \code{peek} methods, and reverse and rotate functionality.
}
\examples{
d = Deque$new(1, 2, s = "a", v = 1:3)
d$addleft(0)
d$peekleft()
d$peek()

d$popleft()
d$rev()

d$rotate()
d$rotate(2)
d$rotate(-3)
}
\seealso{
\code{\link[=Container]{Container()}}, \code{\link[=deque]{deque()}}
}
\section{Super classes}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{\link[container:Container]{container::Container}} -> \code{Deque}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Deque-addleft}{\code{Deque$addleft()}}
\item \href{#method-Deque-peek}{\code{Deque$peek()}}
\item \href{#method-Deque-peekleft}{\code{Deque$peekleft()}}
\item \href{#method-Deque-popleft}{\code{Deque$popleft()}}
\item \href{#method-Deque-rev}{\code{Deque$rev()}}
\item \href{#method-Deque-rotate}{\code{Deque$rotate()}}
\item \href{#method-Deque-clone}{\code{Deque$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter"><a href='../../container/html/Iterable.html#method-Iterable-iter'><code>container::Iterable$iter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="add"><a href='../../container/html/Container.html#method-Container-add'><code>container::Container$add()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at"><a href='../../container/html/Container.html#method-Container-at'><code>container::Container$at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at2"><a href='../../container/html/Container.html#method-Container-at2'><code>container::Container$at2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="clear"><a href='../../container/html/Container.html#method-Container-clear'><code>container::Container$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="count"><a href='../../container/html/Container.html#method-Container-count'><code>container::Container$count()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete"><a href='../../container/html/Container.html#method-Container-delete'><code>container::Container$delete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete_at"><a href='../../container/html/Container.html#method-Container-delete_at'><code>container::Container$delete_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard"><a href='../../container/html/Container.html#method-Container-discard'><code>container::Container$discard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard_at"><a href='../../container/html/Container.html#method-Container-discard_at'><code>container::Container$discard_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="empty"><a href='../../container/html/Container.html#method-Container-empty'><code>container::Container$empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="get_compare_fun"><a href='../../container/html/Container.html#method-Container-get_compare_fun'><code>container::Container$get_compare_fun()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has"><a href='../../container/html/Container.html#method-Container-has'><code>container::Container$has()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has_name"><a href='../../container/html/Container.html#method-Container-has_name'><code>container::Container$has_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="initialize"><a href='../../container/html/Container.html#method-Container-initialize'><code>container::Container$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="is_empty"><a href='../../container/html/Container.html#method-Container-is_empty'><code>container::Container$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="length"><a href='../../container/html/Container.html#method-Container-length'><code>container::Container$length()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="names"><a href='../../container/html/Container.html#method-Container-names'><code>container::Container$names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at"><a href='../../container/html/Container.html#method-Container-peek_at'><code>container::Container$peek_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at2"><a href='../../container/html/Container.html#method-Container-peek_at2'><code>container::Container$peek_at2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="pop"><a href='../../container/html/Container.html#method-Container-pop'><code>container::Container$pop()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="print"><a href='../../container/html/Container.html#method-Container-print'><code>container::Container$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="remove"><a href='../../container/html/Container.html#method-Container-remove'><code>container::Container$remove()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="rename"><a href='../../container/html/Container.html#method-Container-rename'><code>container::Container$rename()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace"><a href='../../container/html/Container.html#method-Container-replace'><code>container::Container$replace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace_at"><a href='../../container/html/Container.html#method-Container-replace_at'><code>container::Container$replace_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="size"><a href='../../container/html/Container.html#method-Container-size'><code>container::Container$size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="type"><a href='../../container/html/Container.html#method-Container-type'><code>container::Container$type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="update"><a href='../../container/html/Container.html#method-Container-update'><code>container::Container$update()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="values"><a href='../../container/html/Container.html#method-Container-values'><code>container::Container$values()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-addleft"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-addleft}{}}}
\subsection{Method \code{addleft()}}{
Add element to left side of the \code{Deque}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$addleft(value, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value of \code{ANY} type to be added to the \code{Deque}.}

\item{\code{name}}{\code{character} optional name attribute of the value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Deque} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-peek"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-peek}{}}}
\subsection{Method \code{peek()}}{
Peek at last element of the \code{Deque}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$peek(default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{default}}{returned default value if \code{Deque} is empty.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
element 'peeked' on the right
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-peekleft"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-peekleft}{}}}
\subsection{Method \code{peekleft()}}{
Peek at first element of the \code{Deque}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$peekleft(default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{default}}{returned default value if \code{Deque} is empty.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
element 'peeked' on the left
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-popleft"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-popleft}{}}}
\subsection{Method \code{popleft()}}{
Delete and return element from the left side of the \code{\link[=Deque]{Deque()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$popleft()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
element 'popped' from the left side of the \code{\link[=Deque]{Deque()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-rev"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-rev}{}}}
\subsection{Method \code{rev()}}{
Reverse all elements of the \code{\link[=Deque]{Deque()}} in-place.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$rev()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the \code{Deque()} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-rotate}{}}}
\subsection{Method \code{rotate()}}{
Rotate all elements \code{n} steps to the right. If n is
negative, rotate to the left.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$rotate(n = 1L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{integer} number of steps to rotate}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Deque()} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Deque-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Deque-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
