% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_continuous.R
\name{forest_cont}
\alias{forest_cont}
\title{Contour-enhanced Forest Plot for Continuous Outcomes}
\usage{
forest_cont(
  dat,
  measure = "SMD",
  method = "REML",
  sort = c("effect", "none"),
  xlab = "",
  title = NULL,
  model = "Random-effects",
  estimator = "REML",
  m_c_col = "mean_c",
  sd_c_col = "sd_c",
  n_c_col = "n_c",
  m_t_col = "mean_t",
  sd_t_col = "sd_t",
  n_t_col = "n_t",
  diamond.col = "red",
  study.col = "blue",
  CI.col = "blue",
  Pred.Inter.col = "black",
  contour_left_min = c(-0.8, -0.5, -0.2, 0),
  contour_left_max = c(-0.5, -0.2, 0, 0.2),
  contour_right_min = c(0, 0.2, 0.5, 0.8),
  contour_right_max = c(0.2, 0.5, 0.8, 1),
  square.size = 10,
  contour_fill = c("gray95", "gray80", "gray60", "gray40"),
  text_size = 3.5,
  pred = TRUE,
  study_x = NULL,
  treatment_x = NULL,
  control_x = NULL,
  effect_x = NULL,
  weight_x = NULL,
  PredInt_x = NULL,
  xlim = NULL,
  hetero_x = -8
)
}
\arguments{
\item{dat}{Data frame containing study-level data. Must include treatment and control means, SDs, sample sizes, and study labels.}

\item{measure}{Effect size measure: \code{"MD"} (mean difference) or \code{"SMD"} (standardized mean difference). Default is \code{"SMD"}.}

\item{method}{Meta-analysis method for \code{rma()} (e.g., \code{"REML"}). Default is \code{"REML"}.}

\item{sort}{Logical. If \code{TRUE}, the studies will be sorted by effect size before plotting.}

\item{xlab}{Label for the x-axis.}

\item{title}{Plot title. If \code{NULL}, a default title including measure is used.}

\item{model}{Model description for heterogeneity annotation. Default \code{"Random-effects"}.}

\item{estimator}{Estimator for heterogeneity. Default \code{"REML"}.}

\item{m_c_col}{Column name for control group means. Default \code{"mean_c"}.}

\item{sd_c_col}{Column name for control group SDs. Default \code{"sd_c"}.}

\item{n_c_col}{Column name for control group sample sizes. Default \code{"n_c"}.}

\item{m_t_col}{Column name for treatment group means. Default \code{"mean_t"}.}

\item{sd_t_col}{Column name for treatment group SDs. Default \code{"sd_t"}.}

\item{n_t_col}{Column name for treatment group sample sizes. Default \code{"n_t"}.}

\item{diamond.col}{Color for the pooled effect diamond. Default \code{"red"}.}

\item{study.col}{Color for study effect points. Default \code{"blue"}.}

\item{CI.col}{Color for study confidence intervals. Default \code{"blue"}.}

\item{Pred.Inter.col}{Color for prediction interval. Default \code{"black"}.}

\item{contour_left_min}{Numeric vector specifying the left-side minimum x-axis
boundaries for contour shading bands (values less than the null effect).}

\item{contour_left_max}{Numeric vector specifying the left-side maximum x-axis
boundaries for contour shading bands (values less than or equal to the null effect).}

\item{contour_right_min}{Numeric vector specifying the right-side minimum x-axis
boundaries for contour shading bands (values greater than or equal to the null effect).}

\item{contour_right_max}{Numeric vector specifying the right-side maximum x-axis
boundaries for contour shading bands (values greater than the null effect).}

\item{square.size}{Size of study points. Default \code{10}.}

\item{contour_fill}{Vector of four colors for contour shading. Default \code{c("gray95","gray80","gray60","gray40")}.}

\item{text_size}{Size of annotated text. Default \code{3.5}.}

\item{pred}{Logical; whether to show prediction interval. Default \code{TRUE}.}

\item{study_x}{X-position for study labels. Default computed automatically.}

\item{treatment_x}{X-position for treatment means. Default computed automatically.}

\item{control_x}{X-position for control means. Default computed automatically.}

\item{effect_x}{X-position for effect sizes. Default computed automatically.}

\item{weight_x}{X-position for weights. Default computed automatically.}

\item{PredInt_x}{X-position for prediction interval label. Default computed automatically.}

\item{xlim}{X-axis limits. Default computed automatically.}

\item{hetero_x}{X-position for heterogeneity annotation. Default \code{-8}.}
}
\value{
A \code{ggplot2} object representing the forest plot.
}
\description{
Creates a forest plot for continuous outcomes (MD or SMD) with optional contour shading,
prediction interval, and annotated study-level means, effect sizes, and weights.
}
\examples{
forest_cont(
  dat1,
  measure = "MD",
  xlab = "Mean Difference",
  study_x = -9,
  sort = "effect",
  hetero_x = -12,
  treatment_x = -7,
  control_x = -5,
  effect_x = 5.5,
  weight_x = 10,
  PredInt_x = 7
)

forest_cont(
  dat1,
  measure = "SMD",
  xlab = "Standardized Mean Difference",
  hetero_x = -9.9,
  study_x = -7,
  sort = "effect",
  treatment_x = -5,
  control_x = -3,
  effect_x = 2.5,
  weight_x = 4,
  PredInt_x = 4
)
forest_cont(
dat1,
study.col = "darkgreen",
CI.col = "black",
diamond.col = "red",
Pred.Inter.col = "black",
measure = "SMD",
sort = "effect",
xlab = "Standardized Mean Difference",
contour_fill = c("gray90","gray70","gray50", "gray30"),
hetero_x = -9.9,
study_x = -7,
square.size = 9,
treatment_x = -5,
control_x = -3.2,
text_size = 4,
effect_x = 2.5,
weight_x = 5.8,
PredInt_x = 3
)
}
