% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assocSelect.R
\name{assocSelect}
\alias{assocSelect}
\title{Select Variable Subsets with Low Association (Mixed-Type Data Frame Interface)}
\usage{
assocSelect(
  df,
  threshold = 0.7,
  method = NULL,
  force_in = NULL,
  method_num_num = c("pearson", "spearman", "kendall", "bicor", "distance", "maximal"),
  method_num_ord = c("spearman", "kendall"),
  method_ord_ord = c("spearman", "kendall"),
  ...
)
}
\arguments{
\item{df}{A data frame (or tibble / data.table). May contain any mix of:
\itemize{
\item numeric / integer (treated as numeric)
\item ordered factors
\item unordered factors (character vectors are coerced to factors)
}}

\item{threshold}{Numeric in \eqn{(0,1)}. Maximum allowed pair-wise
\emph{absolute} association. Default \code{0.7}.}

\item{method}{Character; the subset-search algorithm. One of
\code{"els"} or \code{"bron-kerbosch"}.  If \code{NULL} (default) the
function selects automatically: ELS when \code{force_in} is supplied,
otherwise Bron–Kerbosch.}

\item{force_in}{Optional character vector or column indices specifying
variables that must appear in every returned subset.}

\item{method_num_num}{Association measure for numeric–numeric pairs.
One of \code{"pearson"} (default), \code{"spearman"}, \code{"kendall"},
\code{"bicor"}, \code{"distance"}, or \code{"maximal"}.}

\item{method_num_ord}{Association measure for numeric–ordered pairs.
One of \code{"spearman"} (default) or \code{"kendall"}.}

\item{method_ord_ord}{Association measure for ordered–ordered pairs.
One of \code{"spearman"} (default) or \code{"kendall"}.}

\item{...}{Additional arguments passed unchanged to \code{\link{MatSelect}()}
(e.g., \code{use_pivot = TRUE} for Bron–Kerbosch).}
}
\value{
A \code{\link{CorrCombo}} S4 object containing:
\itemize{
\item all valid subsets,
\item their summary association statistics,
\item metadata (algorithm used, rows kept, forced-in variables, etc.).
}
The object’s \code{show()} method prints the association metrics that were
\emph{actually used} for this data set.
}
\description{
Identifies combinations of variables of any common data type (numeric,
ordered factors, or unordered) factors—whose \emph{pair-wise association} does not
exceed a user-supplied threshold.
The routine wraps \code{\link{MatSelect}()} and handles all pre-processing
(type conversion, missing-row removal, constant-column checks) for typical
data-frame/tibble/data-table inputs.
}
\details{
A single call can therefore screen a data set that mixes continuous and
categorical features and return every subset whose internal associations are
“sufficiently low” under the metric(s) you choose.

Rows containing \code{NA} are dropped with a warning; constant columns are
treated as having zero association with every other variable.

The default association measure for each variable-type combination is:

\describe{
\item{numeric – numeric}{\code{method_num_num} (default \code{"pearson"})}
\item{numeric – ordered}{\code{method_num_ord}}
\item{numeric – unordered}{\code{"eta"} (ANOVA \eqn{\eta^{2}})}
\item{ordered – ordered}{\code{method_ord_ord}}
\item{ordered – unordered}{\code{"cramersv"}}
\item{unordered – unordered}{\code{"cramersv"}}
}

All association measures are rescaled to \eqn{[0,1]} before thresholding.
External packages are required for
\code{"bicor"} (\pkg{WGCNA}),
\code{"distance"} (\pkg{energy}),
and \code{"maximal"} (\pkg{minerva}); an informative error is thrown if they
are missing.
}
\examples{
set.seed(42)
df <- data.frame(
  height = rnorm(15, 170, 10),
  weight = rnorm(15, 70, 12),
  group  = factor(rep(LETTERS[1:3], each = 5)),
  score  = ordered(sample(c("low","med","high"), 15, TRUE))
)

## keep every subset whose internal associations <= 0.6
assocSelect(df, threshold = 0.6)

## use Kendall for all rank-based comparisons and force 'height' to appear
assocSelect(df,
            threshold       = 0.5,
            method_num_num  = "kendall",
            method_num_ord  = "kendall",
            method_ord_ord  = "kendall",
            force_in        = "height")

}
\seealso{
\code{\link[=corrSelect]{corrSelect()}}, \code{\link[=MatSelect]{MatSelect()}}, \code{\link[=corrSubset]{corrSubset()}}
}
