% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportionality.R
\name{pluginVariation}
\alias{pluginVariation}
\title{Plugin Variation}
\usage{
pluginVariation(
  counts,
  type = c("standard", "phi", "phis", "rho"),
  order = c("second", "first"),
  impute.zeros = TRUE,
  ...
)
}
\arguments{
\item{counts}{Matrix of counts; samples are rows and features are columns.}

\item{type}{Type of variation metric to be calculated: \code{standard}, \code{phi},
\code{phis} (a symmetrical version of \code{phi}), \code{rho}, or \code{logp} (the variance-covariance matrix of log-transformed proportions).}

\item{order}{The order of the Taylor-series approximation to be used in the
estimation}

\item{impute.zeros}{If TRUE, then \code{cmultRepl()} from the \code{zCompositions} package is used to impute zero values in the counts matrix.}

\item{...}{Optional arguments passed to zero-imputation function \code{cmultRepl()}}
}
\value{
An estimate of the requested metric of proportionality.
}
\description{
Estimates the variation matrix of count-compositional data
based on a the same approximation used in logitNormalVariation()
only for this function it uses empirical estimates of mu and Sigma.
Also performs zero-imputation using \code{cmultRepl()} from the \code{zCompositions} package.
}
\examples{
data(singlecell)

pluginVariation(singlecell)
pluginVariation(singlecell, type="phi")
pluginVariation(singlecell, type="rho")

}
