% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_vcov.R
\name{coef_vcov}
\alias{coef_vcov}
\title{Extract Regression Coefficients for B-Splines and Tensor Products of B-splines}
\usage{
coef_vcov(fit, theta_idx)
}
\arguments{
\item{fit}{a regression model fit}

\item{theta_idx}{numeric index for the theta related coefficients}
}
\value{
A list with four elements
\describe{
  \item{theta}{theta regression coefficients}
  \item{coef}{all regression coefficients}
  \item{vcov_theta}{subsection of variance-covariance matrix pertaining to the theta values}
  \item{vcov}{full variance-covariance matrix}
}
}
\description{
An S3 method for extracting the regression coefficients of the
\code{bsplines} and \code{btensor} terms.  By Default this uses
\code{stats::coef} to extract all the regression coefficients.  A specific
method for \code{lmerMod} objects has been provided.  If you are using a
regression method which \code{stats::coef} will not return the regression
coefficients, you'll need to define an S3 method for \code{stats::coef} to do
so.
}
\details{
These functions are called in the \code{\link{cp}} and
\code{\link{cn}} calls.
}
\examples{

cp0 <- cp(log10(pdg) ~ bsplines(day, df = 6, bknots = c(-1, 1)) + age + ttm, data = spdg)
cv <- cpr:::coef_vcov(cp0$fit)

summary(cv)

}
\seealso{
\code{\link[stats]{coef}} \code{\link{cp}} \code{\link{cn}}
}
