% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cpr_cp.R
\name{summary.cpr_cp}
\alias{summary.cpr_cp}
\title{Summarize a Control Polygon Object}
\usage{
\method{summary}{cpr_cp}(object, wiggle = TRUE, integrate.args = list(), ...)
}
\arguments{
\item{object}{a \code{cpr_cp} object}

\item{wiggle}{logical, if \code{TRUE} then the integral of the squared second
derivative of the spline function will be calculated via
\code{\link[stats]{integrate}}.}

\item{integrate.args}{a list of arguments passed to \code{\link{wiggle}} and
ultimately \code{\link[stats]{integrate}}.}

\item{...}{pass through}
}
\value{
a \code{cpr_summary_cpr_cp} object, that is just a \code{data.frame}
}
\description{
Summarize a Control Polygon Object
}
\examples{
set.seed(42)
x <- seq(0 + 1/5000, 6 - 1/5000, length.out = 100)
bmat <- bsplines(x, iknots = c(1, 1.5, 2.3, 4, 4.5), bknots = c(0, 6))
theta <- matrix(c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5), ncol = 1)
DF <- data.frame(x = x, truth = as.numeric(bmat \%*\% theta))
DF$y <- as.numeric(bmat \%*\% theta + rnorm(nrow(bmat), sd = 0.3))

initial_cp <-
  cp(y ~ bsplines(x, iknots = c(1, 1.5, 2.3, 3.0, 4, 4.5), bknots = c(0, 6))
     , data = DF
     , keep_fit = TRUE # default is FALSE
  )

summary(initial_cp)

}
