% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticKadaneBetaGamma-class}
\alias{LogisticKadaneBetaGamma-class}
\alias{.LogisticKadaneBetaGamma}
\alias{LogisticKadaneBetaGamma}
\alias{.DefaultLogisticKadaneBetaGamma}
\title{\code{LogisticKadaneBetaGamma}}
\usage{
LogisticKadaneBetaGamma(theta, xmin, xmax, alpha, beta, shape, rate)

.DefaultLogisticKadaneBetaGamma()
}
\arguments{
\item{theta}{(\code{proportion})\cr the target toxicity probability.}

\item{xmin}{(\code{number})\cr the minimum of the dose range.}

\item{xmax}{(\code{number})\cr the maximum of the dose range.}

\item{alpha}{(\code{number})\cr the first shape parameter of the Beta prior distribution
\code{rho0 = p(xmin)} the probability of a DLT at the minimum dose \code{xmin}.}

\item{beta}{(\code{number})\cr the second shape parameter of the Beta prior distribution
\code{rho0 = p(xmin)} the probability of a DLT at the minimum dose \code{xmin}.}

\item{shape}{(\code{number})\cr the shape parameter of the Gamma prior distribution
\code{gamma} the dose with target toxicity probability \code{theta}.}

\item{rate}{(\code{number})\cr the rate parameter of the Gamma prior distribution
\code{gamma} the dose with target toxicity probability \code{theta}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{LogisticKadaneBetaGamma}} is the class for the logistic model in the parametrization
of \insertCite{KadaneDickeyWinklerSmithPeters1980;textual}{crmPack},
using a beta and a gamma distribution as the model priors.
}
\details{
Let \code{rho0 = p(xmin)} be the probability of a DLT at the minimum dose
\code{xmin}, and let \code{gamma} be the dose with target toxicity probability \code{theta},
i.e. \eqn{p(gamma) = theta}. Then it can easily be shown that the logistic
regression model has intercept
\deqn{[gamma * logit(rho0) - xmin * logit(theta)] / [gamma - xmin]}
and slope
\deqn{[logit(theta) - logit(rho0)] / [gamma - xmin].}

The prior for \code{gamma}, is \deqn{gamma ~ Gamma(shape, rate).}.
The prior for \code{rho0 = p(xmin)}, is \deqn{rho0 ~ Beta(alpha, beta).}
}
\section{Slots}{

\describe{
\item{\code{theta}}{(\code{proportion})\cr the target toxicity probability.}

\item{\code{xmin}}{(\code{number})\cr the minimum of the dose range.}

\item{\code{xmax}}{(\code{number})\cr the maximum of the dose range.}

\item{\code{alpha}}{(\code{number})\cr the first shape parameter of the Beta prior distribution
of \code{rho0 = p(xmin)} the probability of a DLT at the minimum dose \code{xmin}.}

\item{\code{beta}}{(\code{number})\cr the second shape parameter of the Beta prior distribution
of \code{rho0 = p(xmin)} the probability of a DLT at the minimum dose \code{xmin}.}

\item{\code{shape}}{(\code{number})\cr the shape parameter of the Gamma prior distribution
of \code{gamma} the dose with target toxicity probability \code{theta}.}

\item{\code{rate}}{(\code{number})\cr the rate parameter of the Gamma prior distribution
of \code{gamma} the dose with target toxicity probability \code{theta}.}
}}

\note{
The slots of this class, required for creating the model, are the same
as in the \code{LogisticKadane} class. In addition, the shape parameters of the
Beta prior distribution of \code{rho0} and the shape and rate parameters of the
Gamma prior distribution of \code{gamma}, are required for creating the prior model.

Typically, end users will not use the \code{.Default()} function.
}
\examples{
my_model <- LogisticKadaneBetaGamma(
  theta = 0.3,
  xmin = 0,
  xmax = 7,
  alpha = 1,
  beta = 19,
  shape = 0.5625,
  rate = 0.125
)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ModelLogNormal}}, \code{\link{LogisticKadane}}.
}
