% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappedcauchy.R
\name{wrappedcauchy}
\alias{wrappedcauchy}
\alias{rwrappedcauchy}
\alias{pwrappedcauchy}
\alias{dwrappedcauchy}
\alias{qwrappedcauchy}
\title{Density, Distribution, Quantiles and Random Number Generation for the Wrapped
Cauchy Distribution}
\usage{
rwrappedcauchy(n, location = 0, scale = 1)

dwrappedcauchy(theta, location = 0, scale = 1)

pwrappedcauchy(theta, location = 0, scale = 1, K = 100, check_prec = FALSE)

qwrappedcauchy(p, location = 0, scale = 1, K = 100, check_prec = FALSE)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rwrappedcauchy()}.}

\item{location}{\link[base]{numeric} value, the mean of the distribution.}

\item{scale}{\link[base]{numeric} value, the parameter tuning the spread of the
density. It must be non-negative.}

\item{theta}{\link[base]{numeric} \link[base]{vector} giving the angles where
the density or distribution function is evaluated.}

\item{K}{\link[base]{integer} value, the number of "wraps" used in each direction
to approximate the distribution.}

\item{check_prec}{\link[base]{logical}, whether to check if the precision of
the numerical approximation with the current parameters is higher than 99\%.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\itemize{
\item{\code{dwrappedcauchy()}}{ gives a \link[base]{vector} of length \code{length(theta)}
 containing the density at \code{theta}.}
\item{\code{pwrappedcauchy()}}{ gives a
\link[base]{vector} of length \code{length(theta)} containing
the distribution function at the corresponding values of \code{theta}.}
\item{\code{qwrappedcauchy()}}{ gives a \link[base]{vector} of length \code{length(p)}
containing the quantiles at the corresponding values of \code{p}.}
\item{\code{rwrappedcauchy()}}{ generates a \link[base]{vector} of length \code{n}
containing the random samples, i.e. angles in \eqn{[-\pi, \pi)}.}
}
}
\description{
The distribution function (\code{pwrappedcauchy()}) and quantiles
 (\code{qwrappedcauchy()}) of the wrapped Cauchy distribution cannot
 be obtained analytically. They are therefore missing in the
'\pkg{circular}' package and are obtained here numerically.
Random number generation (\code{rwrappedcauchy()}) and density
(\code{dwrappedcauchy()}) don't need a numerical
approximation and are provided here for consistency in parametrization
 with the other wrapped Cauchy functions.
}
\details{
One could alternatively  convert \code{scale} to \code{rho} via
\code{rho = exp(-scale)} and use
\code{circular::\link[circular]{rwrappedcauchy}(theta, mu=location rho=rho)} or
\code{circular::\link[circular]{dwrappedcauchy}(theta, mu=location rho=rho)}.

The wrapped Cauchy cdf, for which there is no analytical expression,
is calculated by wrapping the Cauchy distribution \eqn{K} times
 around the circle in each direction and summing the Cauchy cdfs at each point of
  the circle. Let \eqn{\Omega} follow a Cauchy distribution and
  \eqn{\Theta} a wrapped Cauchy distribution, where \eqn{\Theta} can take values
  \eqn{\theta \in [-\pi,\pi)}.
   \eqn{Pr(\Theta \le \theta)} is approximated as
   \deqn{\sum^K_{k=-K}Pr(\Omega \le \theta+2\pi k)-Pr(\Omega \le -\pi+2\pi k).}
   The quantiles are calculated by numerical inversion.
}
\examples{
set.seed(123)

rwrappedcauchy(10, location = 0, scale =3)

dwrappedcauchy(c(0.1, pi), location = pi, scale =2)
circular::dwrappedcauchy(circular::circular(c(0.1,pi)), mu = circular::circular(pi), rho =exp(-2))

prob <- pwrappedcauchy(c(0.1, pi), location = pi, scale =2)
prob
qwrappedcauchy(prob, location = pi, scale =2)

}
\seealso{
\code{circular::\link[circular]{dwrappedcauchy}()},
\code{circular::\link[circular]{rwrappedcauchy}()}.
}
