% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{unpack_traces}
\alias{unpack_traces}
\alias{unpack_traces.traces_dm}
\alias{unpack_traces.traces_dm_list}
\title{Unpack/Destroy Traces Objects}
\usage{
unpack_traces(object, ...)

\method{unpack_traces}{traces_dm}(object, ..., unpack = TRUE)

\method{unpack_traces}{traces_dm_list}(object, ..., unpack = TRUE, conds = NULL)
}
\arguments{
\item{object}{an object of type \code{traces_dm} or \code{traces_dm_list} (see
\code{\link[=simulate_traces]{simulate_traces()}})}

\item{...}{further arguments passed on to the respective method.}

\item{unpack}{logical, indicating if the \code{traces_dm} objects
shall be unpacked. Default is \code{TRUE}.}

\item{conds}{optional character, indicating specific condition(s). The
default \code{NULL} will lead to \code{conds = conds(object)}. Thus, per default all
conditions are accessed.}
}
\value{
For \code{traces_dm_list}, the returned value is a list, if \code{conds} specifies more
than one condition. For example, if \code{conds = c("foo", "bar")}, then the
returned value is a list with the two (named) entries "foo" and "bar". If
the returned list would only have one entry (either because the
\code{traces_dm_list} has only one condition, see \link{conds}, or because a
user explicitly requested only one condition), then the underlying
array or \code{traces_dm} object is returned directly.

For \code{traces_dm}, \code{unpack_traces()} returns an array with the traces, if
\code{unpack=TRUE}. If \code{unpack=FALSE}, the unmodified object is returned.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{unpack_traces()} is deprecated. Please use the more general
\code{\link[=unpack_obj]{unpack_obj()}} function.
}
\details{
\code{unpack_traces()} was a generic function to strip away the "unnecessary"
information of \code{traces_dm_list} and \code{traces_dm} objects. These objects are
created when calling \code{\link[=simulate_traces]{simulate_traces()}}.

For \code{traces_dm_list}, \code{unpack_traces()} returns the
requested conditions (see the argument \code{conds}). The result contains
objects of type \code{traces_dm} if \code{unpack = FALSE}. For \code{unpack = TRUE},
the result contains the plain arrays with the traces.
}
