% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-pspLlancahue.r
\docType{data}
\name{pspLlancahue}
\alias{pspLlancahue}
\title{Ubicación cartesiana de árboles en un bosque (solo como
referencia para uso del libro).}
\format{
Contains tree-level variables, as follows:
\describe{
\item{arb.id}{Identificador del árbol.}
\item{spp}{Codificación de la especie. Detalles en  \code{llancahue2}.}
\item{dap}{Diámetro a la altura del pecho, en cm.}
\item{coord.x}{Posición cartesiana en el eje-X, en m.}
\item{coord.y}{Posición cartesiana en el eje-Y, en m.}
}
}
\source{
Detalles en  \code{llancahue2}.
}
\usage{
data(pspLlancahue)
}
\description{
Esta dataframe solo se mantiene para ser de utilidad a quienes
usan el libro de Salas-eljatib (2021), ya que la nueva
versión se encuentra en la dataframe \code{llancahue2}.
}
\examples{
data(pspLlancahue) 
descstat(pspLlancahue$dap)
boxplot(dap~spp, data=pspLlancahue)
}
\references{
\itemize{
\item Detalles en \code{llancahue2}.
}
}
\keyword{datasets}
