% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_warning.R
\name{util_warning}
\alias{util_warning}
\title{Produce a warning message with a useful short stack trace.}
\usage{
util_warning(
  m,
  ...,
  applicability_problem = NA,
  intrinsic_applicability_problem = NA,
  integrity_indicator = "none",
  level = 0,
  immediate,
  title = "",
  additional_classes = c()
)
}
\arguments{
\item{m}{warning message or a \link{condition}}

\item{...}{arguments for \link{sprintf} on m, if m is a character}

\item{applicability_problem}{\link{logical} \code{TRUE}, if an applicability issue,
that is, the information for
computation is missing
(that is, an error that indicates
missing metadata) or an error because
the requirements of
the stopped function were not met,
e.g., a \code{barplot} was called for
metric data. We can have logical
or empirical applicability problems.
empirical is the default, if the
argument
\code{intrinsic_applicability_problem} is
left unset or set to \code{FALSE}.}

\item{intrinsic_applicability_problem}{\link{logical} \code{TRUE}, if this is a
logical applicability issue, that is,
the computation makes no sense
(for example, an error of unsuitable
\code{resp_vars}). Intrinsic/logical
applicability problems are also
applicability problems. Non-logical
applicability problems are called
empirical applicability problems.}

\item{integrity_indicator}{\link{character} the warning is an integrity problem,
here is the indicator abbreviation..}

\item{level}{\link{integer} level of the warning message (defaults to 0). Higher
levels are more severe.}

\item{immediate}{\link{logical} Display the warning immediately, not only, when
the interactive session comes back.}

\item{additional_classes}{\link{character} additional classes the
thrown condition object should inherit
from, first.}
}
\value{
\link{condition} the condition object, if the execution is not stopped
}
\description{
Produce a warning message with a useful short stack trace.
}
\seealso{
Other condition_functions: 
\code{\link{util_condition_constructor_factory}()},
\code{\link{util_deparse1}()},
\code{\link{util_error}()},
\code{\link{util_find_external_functions_in_stacktrace}()},
\code{\link{util_find_first_externally_called_functions_in_stacktrace}()},
\code{\link{util_find_indicator_function_in_callers}()},
\code{\link{util_message}()},
\code{\link{util_suppress_warnings}()}
}
\concept{condition_functions}
\concept{process}
\keyword{internal}
