% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_scatterplot_matrix.R
\name{des_scatterplot_matrix}
\alias{des_scatterplot_matrix}
\title{Compute Pairwise Correlations}
\usage{
des_scatterplot_matrix(
  label_col,
  study_data,
  item_level = "item_level",
  meta_data_cross_item = "cross-item_level",
  meta_data = item_level,
  meta_data_v2,
  cross_item_level,
  `cross-item_level`
)
}
\arguments{
\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data_cross_item}{\link{meta_data_cross}}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{cross_item_level}{\link{data.frame} alias for \code{meta_data_cross_item}}

\item{`cross-item_level`}{\link{data.frame} alias for \code{meta_data_cross_item}}
}
\value{
a \code{list} with the slots:
\itemize{
\item \code{SummaryPlotList}: for each variable group a \link[ggplot2:ggplot]{ggplot2::ggplot} object with
pairwise correlation plots
\item \code{SummaryData}: table with columns \code{VARIABLE_LIST}, \code{cors},
\code{max_cor}, \code{min_cor}
\item \code{SummaryTable}: like \code{SummaryData}, but machine readable and with
stable column names.
}
}
\description{
works on variable groups (\code{cross-item_level}), which are expected to show
a Pearson correlation
}
\details{
\link{Descriptor} # TODO: This can be an indicator
}
\examples{
\dontrun{
devtools::load_all()
prep_load_workbook_like_file("meta_data_v2")
des_scatterplot_matrix("study_data")
}
}
