% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_to_iso.R
\name{clean_date}
\alias{clean_date}
\title{Prepare and normalize date-like strings before YMD conversion}
\usage{
clean_date(df_column)
}
\arguments{
\item{df_column}{A character vector or data frame column containing raw
date-like strings to be cleaned.}
}
\value{
A character vector of cleaned date strings, with a maximum length
of 12 characters, trimmed of whitespace, and with any timestamp-like
"T" components removed when appropriate.
}
\description{
This function applies a series of cleaning and normalization steps to
strings representing dates. It is intended for use before parsing dates
into a YMD (year–month–day) format. The function standardizes month names,
trims whitespace, removes invalid characters, and handles strings that
contain a letter "T" (common in timestamp formats).
}
\details{
The processing includes:
\itemize{
  \item Converting full month names to abbreviated forms
        (via \code{get_abbreviated_month_name()}).
  \item Limiting the string to the first 12 characters
        (via \code{get_up_to_12_char()}).
  \item Removing non-date characters
        (via \code{remove_no_date_characters()}).
  \item Trimming whitespace at the start and end of the string.
  \item Handling timestamps or strings containing the letter "T":
    \itemize{
      \item If "T" appears exactly once and the string does not contain
            "August" or "October", keep only the substring before "T".
      \item If "T" appears multiple times, remove the unnecessary trailing
            part using \code{remove_unnecessary_part_of_date()}.
    }
  \item If the first token of the string (separated by a space) is longer
        than four characters, return only that first token.
}
}
\examples{
clean_date(c("2024-01-10T15:30:00", "2024 AUGUST 12", "20250101"))
}
\author{
Lukasz Andrzejewski
}
