% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbn_learn.R
\name{fit_dbn_params}
\alias{fit_dbn_params}
\title{Fits a markovian n DBN model}
\usage{
fit_dbn_params(net, f_dt, ...)
}
\arguments{
\item{net}{the structure of the DBN}

\item{f_dt}{a folded data.table}

\item{...}{additional parameters for the \code{\link[bnlearn]{bn.fit}} function}
}
\value{
a "dbn.fit" S3 object with the fitted net
}
\description{
Fits the parameters of the DBN via MLE. The "mu" vector of means 
and the "sigma" covariance matrix are set as attributes of the dbn.fit 
object for future exact inference.
}
\examples{
size = 3
dt_train <- dbnR::motor[200:2500]
net <- learn_dbn_struc(dt_train, size)
f_dt_train <- fold_dt(dt_train, size)
fit <- fit_dbn_params(net, f_dt_train, method = "mle-g")
}
