% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Guo_Tanaka_2001}
\alias{Guo_Tanaka_2001}
\title{Data: Guo and Tanaka (2001).}
\format{
Data frame with 5 rows and 9 columns. Definition of fuzzy inputs (X)
and fuzzy outputs (Y):
\describe{
  \item{x1}{Input 1}
  \item{x2}{Input 2}
  \item{alpha1}{spread vector Input 1}
  \item{alpha2}{spread vector Input 2}
  \item{y1}{Output 1}
  \item{y2}{Output 2}
  \item{beta1}{spread vector Output 1}
  \item{beta2}{spread vector Output 2}
}
}
\source{
Guo, P.; Tanaka, H. (2001). "Fuzzy DEA: A Perceptual Evaluation Method",
Fuzzy Sets and Systems, 119, 149–160. \doi{10.1016/S0165-0114(99)00106-2}
}
\usage{
data("Guo_Tanaka_2001")
}
\description{
Data of 5 DMUs with two symmetric triangular fuzzy inputs, Xj = (xj, alphaj), and
two symmetric triangular fuzzy outputs, Yj = (yj, betaj).
}
\examples{
data("Guo_Tanaka_2001")
data_example <- make_deadata_fuzzy(Guo_Tanaka_2001,
                                   dmus = 1,
                                   inputs.mL = 2:3,
                                   inputs.dL = 4:5,
                                   outputs.mL = 6:7,
                                   outputs.dL = 8:9)
result <- modelfuzzy_guotanaka(data_example,
                               h = seq(0, 1, by = 0.1),
                               orientation = "io")
efficiencies(result)

}
\seealso{
\code{\link{make_deadata_fuzzy}}, \code{\link{modelfuzzy_guotanaka}},
\code{\link{cross_efficiency_fuzzy}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
