% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_fuzzy.R
\name{read_data_fuzzy}
\alias{read_data_fuzzy}
\title{read_data_fuzzy}
\usage{
read_data_fuzzy(datadea,
                dmus = 1,
                inputs.mL = NULL,
                inputs.mR = NULL,
                inputs.dL = NULL,
                inputs.dR = NULL,
                outputs.mL = NULL,
                outputs.mR = NULL,
                outputs.dL = NULL,
                outputs.dR = NULL,
                nc_inputs = NULL,
                nc_outputs = NULL,
                nd_inputs = NULL,
                nd_outputs = NULL,
                ud_inputs = NULL,
                ud_outputs = NULL)
}
\arguments{
\item{datadea}{Data frame with DEA data.}

\item{dmus}{Column (number or name) of DMUs (optional). By default, it is the first
column. If there is not any DMU column, then it must be \code{NULL}.}

\item{inputs.mL}{Where are (columns) the \code{mL} (left centers) of trapezoidal fuzzy
inputs in \code{datadea}. If an input is triangular or crisp, we put the column
where the centers or the crisp values are, respectively.

Alternatively to \code{datadea}, \code{inputs.mL} can be a matrix of size (number of inputs x
number of DMUs) with the \code{mL} of trapezoidal fuzzy inputs, the centers of
triangular inputs, and the crisp values of crisp inputs. In this case, DMUs names are
taken from the columns names.}

\item{inputs.mR}{Where are (columns) the \code{mR} (right centers) of trapezoidal fuzzy
inputs in \code{datadea}. If an input is triangular or crisp, we put \code{NA}.

Alternatively to \code{datadea}, \code{inputs.mR} can be a matrix of size (number of inputs x
number of DMUs) with the \code{mR} of trapezoidal fuzzy inputs, the centers of
triangular inputs, and the crisp values of crisp inputs. If all inputs are triangular or
crisp, then \code{inputs.mR} must be NULL (default) or equal to \code{inputs.mL}.}

\item{inputs.dL}{Where are (columns) the \code{dL} (left radii) of trapezoidal and
triangular fuzzy inputs in \code{datadea}. If an input is symmetric, we put the column
where the radii are. If an input is rectangular or crisp, we put \code{NA}.

Alternatively to \code{datadea}, \code{inputs.dL} can be a matrix of size (number of inputs x
number of DMUs) with the \code{dL} of trapezoidal and triangular fuzzy inputs. If an
input is rectangular or crisp, its radius is zero. If all inputs are rectangular or
crisp, then \code{inputs.dL} must be NULL (default) or a zero matrix.}

\item{inputs.dR}{Where are (columns) the \code{dR} (right radii) of trapezoidal and
triangular fuzzy inputs in \code{datadea}. If an input is symmetric, rectangular or
crisp, we put \code{NA}.

Alternatively to \code{datadea}, \code{inputs.dR} can be a matrix of size (number of inputs x
number of DMUs) with the \code{dR} of trapezoidal and triangular fuzzy inputs. If an
input is rectangular or crisp, its radius is zero. If all inputs are symmetric,
rectangular or crisp, then \code{inputs.dR} must be NULL (default) or equal to
\code{inputs.dL}.}

\item{outputs.mL}{Analogous to \code{inputs.mL}, but relating to outputs.}

\item{outputs.mR}{Analogous to \code{inputs.mR}, but relating to outputs.}

\item{outputs.dL}{Analogous to \code{inputs.dL}, but relating to outputs.}

\item{outputs.dR}{Analogous to \code{inputs.dR}, but relating to outputs.}

\item{nc_inputs}{A numeric vector containing the indices of non-controllable inputs.}

\item{nc_outputs}{A numeric vector containing the indices of non-controllable outputs.}

\item{nd_inputs}{A numeric vector containing the indices of non-discretionary inputs.}

\item{nd_outputs}{A numeric vector containing the indices of non-discretionary outputs.}

\item{ud_inputs}{A numeric vector containing the indices of undesirable (good) inputs.}

\item{ud_outputs}{A numeric vector containing the indices of undesirable (bad) outputs.}
}
\description{
This function is deprecated. Use \code{make_deadata_fuzzy} instead.
}
