% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deformula.R
\name{deformula.moneone}
\alias{deformula.moneone}
\title{Integration of one-dimensional functions over finite interval
with the double exponential formula.}
\usage{
deformula.moneone(
  f,
  lower,
  upper,
  ...,
  zero.eps = 1e-12,
  rel.tol = 1e-08,
  start.divisions = 8,
  max.iter = 12
)
}
\arguments{
\item{f}{An R function taking a numeric first argument.}

\item{lower}{The lower limit of integration.}

\item{upper}{The upper limit of integration.}

\item{...}{Additional arguments to be passed to ‘f’.}

\item{zero.eps}{A threshold value to be zero.}

\item{rel.tol}{A relative accuracy requested.}

\item{start.divisions}{An integer. The initial number of subintervals.}

\item{max.iter}{An integer for the maximum number of iterations to increase
subintervals.}
}
\value{
A list with components;
\item{value}{A value for integral.}
\item{x}{A vector of subintervals.}
\item{w}{A vector of weights.}
\item{t}{A vector of subintervals for trapezoid integral.}
\item{h}{A value of subinterval.}
\item{message}{OK or a string for the error message.}
}
\description{
Numerical quadrature of functions of one variable over
(lower, upper) with the double exponential formula.
}
\examples{
f <- function(x, a) exp(-a*x)
deformula.moneone(f, 0, 1, a=0.1)
}
