% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_eml_xml.R
\name{as_eml_xml}
\alias{as_eml_xml}
\alias{as_eml_xml.tbl_lp}
\alias{as_eml_xml.tbl_df}
\alias{as_eml_xml.list}
\alias{as_eml_xml.xml_document}
\title{Convert metadata to an \code{xml_document}}
\usage{
as_eml_xml(x, ...)

\method{as_eml_xml}{tbl_lp}(x, ...)

\method{as_eml_xml}{tbl_df}(x, ...)

\method{as_eml_xml}{list}(x, ...)

\method{as_eml_xml}{xml_document}(x, ...)
}
\arguments{
\item{x}{Object to be converted.}

\item{...}{Other arguments, currently ignored.}
}
\value{
An \code{xml_document} with the specified nodes and attributes.
}
\description{
Takes a \code{character} vector, tibble, or \code{list} and converts it to an
\code{xml_document}, as defined by the \code{xml2} package. When converting from
a list, this is simply a wrapper for \code{xml2::as_xml_document()}.
}
\examples{
source_file <- system.file("extdata", 
                           "bionet_metadata.Rmd",
                           package = "delma")
df <- read_md(source_file)
as_eml_list(df) |> str()
}
