% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delma-package.R
\docType{package}
\name{delma-package}
\alias{delma}
\alias{delma-package}
\title{Convert metadata between markdown and EML}
\description{
Ecological Metadata Language (EML) is a common
framework for describing ecological datasets so they can be shared and reused.
\code{delma} supports users to write metadata statements in R Markdown or Quarto
Markdown for greater transparency and ease-of-use, then convert them to
EML for efficient transfer.
}
\section{Functions}{


\strong{Main functions}
\itemize{
\item \code{\link[=use_metadata_template]{use_metadata_template()}} - Create a template boilerplate metadata statement
\item \code{\link[=read_eml]{read_eml()}}/\code{\link[=write_eml]{write_eml()}} - Read / write EML files to a \code{tibble}
\item \code{\link[=read_md]{read_md()}}/\code{\link[=write_md]{write_md()}} - Read / write Rmd or qmd files to a \code{tibble}
\item \code{\link[=check_metadata]{check_metadata()}} - Run checks on an EML document
}

\strong{Format manipulation}
\itemize{
\item \code{\link[=as_lp_tibble]{as_lp_tibble()}} - Convert metadata to class a \code{tibble} (class \code{tbl_lp})
\item \code{\link[=as_eml_tibble]{as_eml_tibble()}} - Convert metadata to class a \code{tibble} (class \code{tbl_df})
\item \code{\link[=as_eml_list]{as_eml_list()}} - Convert metadata to class \code{list}
\item \code{\link[=as_eml_xml]{as_eml_xml()}}- Convert metadata to class \code{xml_document}
}
}

\references{
If you have any questions, comments or suggestions, please email
\href{mailto:support@ala.org.au}{support@ala.org.au}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://delma.ala.org.au}
  \item Report bugs at \url{https://github.com/AtlasOfLivingAustralia/delma/issues}
}

}
\author{
\strong{Maintainer}: Martin Westgate \email{martin.westgate@csiro.au}

Authors:
\itemize{
  \item Shandiya Balasubramaniam \email{shandiya.balasubramaniam@csiro.au}
  \item Dax Kellie \email{dax.kellie@csiro.au}
}

}
\keyword{internal}
