% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-examples.R
\name{run_examples}
\alias{run_examples}
\title{Run all examples in a package.}
\usage{
run_examples(
  pkg = ".",
  start = NULL,
  show = deprecated(),
  run_donttest = FALSE,
  run_dontrun = FALSE,
  fresh = FALSE,
  document = TRUE,
  run = deprecated(),
  test = deprecated()
)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{start}{Where to start running the examples: this can either be the
name of \code{Rd} file to start with (with or without extensions), or
a topic name. If omitted, will start with the (lexicographically) first
file. This is useful if you have a lot of examples and don't want to
rerun them every time you fix a problem.}

\item{show}{DEPRECATED.}

\item{run_donttest}{if \code{TRUE}, do run \verb{\\donttest} sections in the Rd files.}

\item{run_dontrun}{if \code{TRUE}, do run \verb{\\dontrun} sections in the Rd files.}

\item{fresh}{if \code{TRUE}, will be run in a fresh R session. This has
the advantage that there's no way the examples can depend on anything in
the current session, but interactive code (like \code{\link[=browser]{browser()}})
won't work.}

\item{document}{if \code{TRUE}, \code{\link[=document]{document()}} will be run to ensure
examples are updated before running them.}

\item{run, test}{Deprecated, see \code{run_dontrun} and \code{run_donttest} above.}
}
\description{
One of the most frustrating parts of \verb{R CMD check} is getting all of your
examples to pass - whenever one fails you need to fix the problem and then
restart the whole process.  This function makes it a little easier by
making it possible to run all examples from an R function.
}
\concept{example functions}
\keyword{programming}
