% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORD.R
\name{ORD}
\alias{ORD}
\title{DIF likelihood ratio statistics for ordinal data.}
\usage{
ORD(Data, group, model = "adjacent", type = "both", match = "zscore",
    anchor = 1:ncol(Data), p.adjust.method = "none",
    alpha = 0.05, parametrization)
}
\arguments{
\item{Data}{data.frame or matrix: dataset which rows represent
ordinally scored examinee answers and columns correspond to the
items.}

\item{group}{numeric: binary vector of group membership. \code{"0"}
for reference group, \code{"1"} for focal group.}

\item{model}{character: logistic regression model for ordinal data
(either \code{"adjacent"} (default) or \code{"cumulative"}). See
\strong{Details}.}

\item{type}{character: type of DIF to be tested. Either
\code{"both"} for uniform and non-uniform DIF (i.e., difference
in parameters \code{"a"} and \code{"b"}) (default), or
\code{"udif"} for uniform DIF only (i.e., difference in
difficulty parameter \code{"b"}), or \code{"nudif"} for
non-uniform DIF only (i.e., difference in discrimination
parameter \code{"a"}). Can be specified as a single value (for
all items) or as an item-specific vector.}

\item{match}{numeric or character: matching criterion to be used as
an estimate of trait. Can be either \code{"zscore"} (default,
standardized total score), \code{"score"} (total test score), or
vector of the same length as number of observations in
\code{Data}.}

\item{anchor}{character or numeric: specification of DIF free
items. A vector of item identifiers (integers specifying the
column  number) specifying which items are currently considered
as anchor (DIF free) items. Argument is ignored if \code{match}
is not \code{"zscore"} or \code{"score"}.}

\item{p.adjust.method}{character: method for multiple comparison
correction. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"},
\code{"fdr"}, and \code{"none"} (default). For more details see
\code{\link[stats]{p.adjust}}.}

\item{alpha}{numeric: significance level (default is 0.05).}

\item{parametrization}{deprecated. Use
\code{\link[difNLR]{coef.difORD}} for different
parameterizations.}
}
\value{
A list with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{par.m0}}{the estimates of null model.}
  \item{\code{par.m1}}{the estimates of alternative model.}
  \item{\code{se.m0}}{standard errors of parameters in null model.}
  \item{\code{se.m1}}{standard errors of parameters in alternative model.}
  \item{\code{cov.m0}}{list of covariance matrices of item parameters for null model.}
  \item{\code{cov.m1}}{list of covariance matrices of item parameters for alternative model.}
  \item{\code{ll.m0}}{log-likelihood of null model.}
  \item{\code{ll.m1}}{log-likelihood of alternative model.}
  \item{\code{AIC.m0}}{AIC of null model.}
  \item{\code{AIC.m1}}{AIC of alternative model.}
  \item{\code{BIC.m0}}{BIC of null model.}
  \item{\code{BIC.m1}}{BIC of alternative model.}
  }
}
\description{
Calculates DIF likelihood ratio statistics for ordinal
  data based either on adjacent category logit regression model or
  on cumulative logit regression model.
}
\details{
Calculates DIF likelihood ratio statistics based either on adjacent
category logit model or on cumulative logit model for ordinal data.

Using adjacent category logit model, logarithm of ratio of
probabilities of two adjacent categories is
\deqn{log(P(y = k) / P(y = k - 1)) = b_0k + b_1 * x + b_2k * g + b_3 * x:g,}
where \eqn{x} is by default standardized total score (also called
Z-score) and \eqn{g} is a group membership.

Using cumulative logit model, probability of gaining at least
\eqn{k} points is given by 2PL model, i.e.,
\deqn{P(y >= k) = exp(b_0k + b_1 * x + b_2k * g + b_3 * x:g) / (1 + exp(b_0k + b_1 * x + b_2k * g + b_3 * x:g)).}
The category probability (i.e., probability of gaining exactly
\eqn{k} points) is then \eqn{P(y = k) = P(y >= k) - P(y >= k + 1)}.

Both models are estimated by iteratively reweighted least squares.
For more details see \code{\link[VGAM]{vglm}}.
}
\examples{
\dontrun{
# loading data
data(Anxiety, package = "ShinyItemAnalysis")
Data <- Anxiety[, paste0("R", 1:29)] # items
group <- Anxiety[, "gender"] # group membership variable

# testing both DIF effects
ORD(Data, group, type = "both")

# testing uniform DIF effects
ORD(Data, group, type = "udif")

# testing non-uniform DIF effects
ORD(Data, group, type = "nudif")

# testing DIF using cumulative logit model
ORD(Data, group, model = "cumulative")
}

}
\references{
Agresti, A. (2010). Analysis of ordinal categorical data. Second edition. John Wiley & Sons.

Hladka, A. (2021). Statistical models for detection of differential item functioning. Dissertation thesis.
Faculty of Mathematics and Physics, Charles University.

Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression models for DIF and DDF detection.
The R Journal, 12(1), 300--323, \doi{10.32614/RJ-2020-014}.
}
\seealso{
\code{\link[stats]{p.adjust}} \code{\link[VGAM]{vglm}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{DIF}
