% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{plot.disclapmixfit}
\alias{plot.disclapmixfit}
\title{Plot a disclapmixfit}
\usage{
\method{plot}{disclapmixfit}(x, which = 1L, clusdist = clusterdist(x), ...)
}
\arguments{
\item{x}{a \code{\link{disclapmixfit}} object, usually from a result of a
call to \code{disclapmix}.}

\item{which}{What plot to make. 1L = clusters and their distances.}

\item{clusdist}{To use previously computed cluster distances to avoid doing
the same computations twice.}

\item{...}{not used}
}
\value{
A data frame with discrete Laplace distributions for each cluster
and locus. Side effect: A plot.
}
\description{
Plot a \code{\link{disclapmixfit}} object.
}
\examples{

data(danes)
db <- as.matrix(danes[rep(1:nrow(danes), danes$n), 1:(ncol(danes)-1)])
fit <- disclapmix(db, clusters = 4L)
plot(fit)

}
\seealso{
\code{\link{disclapmix}} \code{\link{disclapmixfit}}
\code{\link{predict.disclapmixfit}} \code{\link{print.disclapmixfit}}
\code{\link{simulate.disclapmixfit}} \code{\link{summary.disclapmixfit}}
%\code{\link{haplotype_diversity}} \code{\link{clusterdist}}
}
\keyword{plot}
