% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_exponential.R
\name{dist_exponential}
\alias{dist_exponential}
\title{The Exponential Distribution}
\usage{
dist_exponential(rate)
}
\arguments{
\item{rate}{vector of rates.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
dist <- dist_exponential(rate = c(2, 1, 2/3))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Exponential]{stats::Exponential}
}
