% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_scale.R
\name{robust_scale}
\alias{robust_scale}
\title{Robust Scaling of Numeric and Categorical Variables}
\usage{
robust_scale(x, group)
}
\arguments{
\item{x}{A numeric vector, factor, matrix, or data frame. If a matrix or data frame is provided, scaling is applied
column-wise.}

\item{group}{vector indicating which group is the TG to scale to}
}
\value{
A scaled numeric vector or a data frame with scaled columns.
}
\description{
Applies robust scaling to numeric and categorical variables. For numeric variables,
the function centers by the median and scales by the MAD. For categorical variables
with 2–4 unique levels, it applies a custom transformation to map them to numeric values.
}
\details{
This function is designed to make numeric and categorical variables comparable.
This is an internal function that should not be used by package users.
}
\examples{

dat<-data.frame(x=rnorm(100, 10, 3), sex=factor(rbinom(100, 1, 0.5), labels=c("M","F")))

x<- robust_scale(dat$x, dat$sex)
round(median(x), 2)
round(mad(x), 2)

}
