% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{euclidean}
\alias{euclidean}
\title{Euclidean}
\usage{
euclidean(counts, weighted = TRUE, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{weighted}{If \code{TRUE}, the algorithm takes relative abundances into
account. If \code{FALSE}, only presence/absence is considered.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Euclidean beta diversity metric.
}
\section{Calculation}{


In the formulas below, \code{x} and \code{y} are two columns (samples) from \code{counts}.
\code{n} is the number of rows (OTUs) in \code{counts}.

\deqn{D = \displaystyle \sqrt{\sum_{i = 1}^{n} (x_i - y_i)^{2}}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 2, 6)  
  y <- c(0, 8, 0, 0, 5)  
  sqrt(sum((x-y)^2))
  #>  9.69536
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Euclidean weighted distance matrix
    euclidean(ex_counts)
    
    # Euclidean unweighted distance matrix
    euclidean(ex_counts, weighted = FALSE)
    
    # Only calculate distances for A vs all.
    euclidean(ex_counts, pairs = 1:3)
    
}
\references{
Gower JC, Legendre P 1986.
Metric and Euclidean Properties of Dissimilarity Coefficients.
Journal of Classification. 3.
\doi{10.1007/BF01896809}

Legendre P, Caceres M 2013.
Beta diversity as the variance of community data: dissimilarity coefficients and partitioning.
Ecology Letters. 16(8).
\doi{10.1111/ele.12141}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
