% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.egor.R
\name{rowlist}
\alias{rowlist}
\title{Convert a table to a list of rows}
\usage{
rowlist(x)
}
\arguments{
\item{x}{a \code{\link[=data.frame]{data.frame()}}, a \code{\link[=tibble]{tibble()}}, or some other table data
structure backed by a \code{\link[=list]{list()}} of columns.}
}
\value{
A \code{\link[=list]{list()}} of length \code{nrow(x)}, with each element itself a
named \code{\link[=list]{list()}} containing the elements in the corresponding
row.
}
\description{
A convenience function converting a \code{\link[=data.frame]{data.frame()}} or a \code{\link[=tibble]{tibble()}}.
}
\examples{

library(tibble)
(df <- tibble(x=2:1, y=list(list(1:3), list(3:4))))
rowlist(df)

}
