% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.em.R
\name{plot.em}
\alias{plot.em}
\title{Plot the fitted results of EM algorithm}
\usage{
\method{plot}{em}(
  x,
  by = c("component", "prob"),
  prior = FALSE,
  cols = rep(1, length(x$models)),
  lwds = rep(3, length(x$models)),
  ltys = c(seq_len(length(x$models))),
  ranges = NULL,
  main = NULL,
  lgd = list(),
  lgd.loc = "topleft",
  hist.args = list(main = "Histograms of posterior probabilities", xlab =
    "Posterior Probabilities"),
  ...
)
}
\arguments{
\item{x}{the `em` model to plot}

\item{by}{the type of the graph to produce. The default is `component`.}

\item{prior}{whether fit the model using prior probabilities.}

\item{cols}{lines' colors.}

\item{lwds}{Lines' widths.}

\item{ltys}{lines' types.}

\item{ranges}{the ranges of the x-axis and the y-axis limits of plots.
It should be a vector of four numeric values. The first two represent the x-axis limits.
The last two represent the y-axis limits}

\item{main}{the main title.}

\item{lgd}{a list for legend related arguments.}

\item{lgd.loc}{the location of the legend. The default is "topleft".}

\item{hist.args}{The list of arguments for the histogram.}

\item{...}{other arguments.}
}
\value{
`NULL`
}
\description{
This is the generic plot function for `em` project. One can produce
three types of graphs using this function
1. A graph of the predicted value distribution for each component.
2. A histogram of posterior probability distributions
}
