% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correspondencia_logradouro.R
\name{correspondencia_logradouro}
\alias{correspondencia_logradouro}
\title{Correspondência entre os campos do logradouro completo e as colunas que os
descrevem}
\usage{
correspondencia_logradouro(
  tipo_de_logradouro = NULL,
  nome_do_logradouro = NULL,
  numero = NULL
)
}
\arguments{
\item{tipo_de_logradouro, nome_do_logradouro, numero}{Uma string. O nome da
coluna que representa o respectivo campo do logradouro no dataframe. Pode
ser \code{NULL}, no caso do campo não estar listado. Ao menos um dos campos deve
receber um valor não nulo.}
}
\value{
Um vetor nomeado de caracteres, em que os nomes representam os campos
do logradouro e os valores as colunas que os descrevem no dataframe.
}
\description{
Cria um vetor de caracteres que especifica as colunas que representam os
campos de logradouro (tipo, nome e número) em um dataframe de endereços.
}
\examples{
enderecos <- data.frame(
  tipo = "r",
  log = "ns sra da piedade",
  nroLogradouro = 20
)

# dado o dataframe acima, a seguinte chamada cria a correspondencia entre
# suas colunas e os campos
correspondencia_logradouro(
  tipo_de_logradouro = "tipo",
  nome_do_logradouro = "log",
  numero = "nroLogradouro"
)

}
