% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens.conf-legacy.R
\name{probsens.conf_legacy}
\alias{probsens.conf_legacy}
\title{Legacy version of \code{probsens.conf()}.}
\usage{
probsens.conf_legacy(
  case,
  exposed,
  reps = 1000,
  prev.exp = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal", "beta"), parms = NULL),
  prev.nexp = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal", "beta"), parms = NULL),
  risk = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "log-logistic", "log-normal"), parms = NULL),
  corr.p = NULL,
  discard = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated against.}

\item{exposed}{Exposure variable.}

\item{reps}{Number of replications to run.}

\item{prev.exp}{List defining the prevalence of exposure among the exposed. The first argument provides the probability distribution function (constant, uniform, triangular, trapezoidal, logit-logistic, logit-normal, or beta) and the second its parameters as a vector. Logit-logistic and logit-normal distributions can be shifted by providing lower and upper bounds. Avoid providing these values if a non-shifted distribution is desired.
\enumerate{
\item constant: constant value,
\item uniform: min, max,
\item triangular: lower limit, upper limit, mode,
\item trapezoidal: min, lower mode, upper mode, max.
\item logit-logistic: location, scale, lower bound shift, upper bound shift,
\item logit-normal: location, scale, lower bound shift, upper bound shift.
\item beta: alpha, beta.
}}

\item{prev.nexp}{List defining the prevalence of exposure among the unexposed.}

\item{risk}{List defining the confounder-disease relative risk or the confounder-exposure odds ratio. The first argument provides the probability distribution function (constant, uniform, triangular, trapezoidal, log-logistic, or log-normal) and the second its parameters as a vector:
\enumerate{
\item constant: constant value,
\item uniform: min, max,
\item triangular: lower limit, upper limit, mode,
\item trapezoidal: min, lower mode, upper mode, max.
\item log-logistic: shape, rate. Must be strictly positive,
\item log-normal: meanlog, sdlog. This is the mean and standard deviation on the log scale.
}}

\item{corr.p}{Correlation between the exposure-specific confounder prevalences.}

\item{discard}{A logical scalar. In case of negative adjusted count, should the draws be discarded? If set to FALSE, negative counts are set to zero.}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of observed relative risk and odds ratio with confidence intervals.}
\item{adj.measures}{A table of corrected relative risks and odds ratios.}
\item{sim.df}{Data frame of random parameters and computed values.}
\item{reps}{Number of replications.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

episensr 2.0.0 introduced breaking changes in probabilistic bias analyses by
(1) using the NORTA transformation to define a correlation between
distributions, and (2) sampling true prevalences and then sampling the
adjusted cell counts rather than just using the expected cell counts from a
simple quantitative bias analysis. This updated version should be preferred
and this legacy version will be deprecated in future versions. However, if
you need to quickly roll back to the previous calculations, this function
provides the previous interface. To make old code work as is, add the
following code to the top of your script:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(episensr)
probsens.conf <- probsens.conf_legacy
}\if{html}{\out{</div>}}
}
\examples{
# The data for this example come from:
# Tyndall M.W., Ronald A.R., Agoki E., Malisa W., Bwayo J.J., Ndinya-Achola J.O. et al.
# Increased risk of infection with human immunodeficiency virus type 1 among
# uncircumcised men presenting with genital ulcer disease in Kenya.
# Clin Infect Dis 1996;23:449-53.
\dontrun{
set.seed(123)
probsens.conf(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")), nrow = 2, byrow = TRUE),
reps = 20000,
prev.exp = list("triangular", c(.7, .9, .8)),
prev.nexp = list("trapezoidal", c(.03, .04, .05, .06)),
risk = list("triangular", c(.6, .7, .63)),
corr.p = .8)

set.seed(123)
probsens.conf(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")), nrow = 2, byrow = TRUE),
reps = 20000,
prev.exp = list("beta", c(200, 56)),
prev.nexp = list("beta", c(10, 16)),
risk = list("triangular", c(.6, .7, .63)),
corr.p = .8)
}
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.
}
