% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aki.R
\name{aki_staging}
\alias{aki_staging}
\alias{aki_staging.data.frame}
\alias{aki_staging.units}
\alias{aki_staging.numeric}
\title{Codify AKI from Serum Creatinine and/or Urine Output}
\usage{
aki_staging(...)

\method{aki_staging}{data.frame}(
  .data,
  SCr = NULL,
  bCr = NULL,
  UO = NULL,
  dttm = NULL,
  pt_id = NULL,
  ...
)

\method{aki_staging}{units}(SCr = NULL, bCr = NULL, UO = NULL, dttm = NULL, pt_id = NULL, ...)

\method{aki_staging}{numeric}(SCr = NULL, bCr = NULL, UO = NULL, dttm = NULL, pt_id = NULL, ...)
}
\arguments{
\item{...}{Further optional arguments}

\item{.data}{(data.frame) A data.frame, optional}

\item{SCr}{Serum creatinine
column name, or vector of units or numeric if \code{.data} is not provided}

\item{bCr}{Baseline creatinine
column name, or vector of units or numeric if \code{.data} is not provided}

\item{UO}{Urine output
column name, or vector of units or numeric if \code{.data} is not provided}

\item{dttm}{DateTime
column name, or vector of POSIXct if \code{.data} is not provided}

\item{pt_id}{Patient ID
column name, or vector of characters or factors if \code{.data} is not provided}
}
\value{
(ordered factor) AKI stages
}
\description{
Using KDIGO Clinical Practice Guideline for
Acute Kidney Injury
Volume 2 | Issue 1 | March 2012
}
\details{
Provided a baseline creatinine, series of Serum Creatinine readings and/or
Urine Output, \code{aki_staging()} calculates whether or not a patient has AKI.
The staging (1, 2, 3) of AKI is returned.

When multiple columns are provided, \code{aki_staging()} will automatically
calculate whether or not AKI has occurred using each KDIGO definition.

\itemize{
\item{\code{\link[=aki_bCr]{aki_bCr()}}: Staging of AKI based on baseline serum creatinine}
\item{\code{\link[=aki_SCr]{aki_SCr()}}: Staging of AKI based on changes in serum creatinine}
\item{\code{\link[=aki_UO]{aki_UO()}}: Staging of AKI based on urine output}
}

The most severe AKI stage is then returned.

See \url{https://kdigo.org/guidelines/acute-kidney-injury/} for more details.
}
\examples{
aki_staging(aki_pt_data, SCr = "SCr_", bCr = "bCr_", UO = "UO_", dttm = "dttm_", pt_id = "pt_id_")

aki_pt_data \%>\%
  dplyr::mutate(aki = aki_staging(SCr = SCr_, bCr = bCr_, UO = UO_, dttm = dttm_, pt_id = pt_id_))
}
