% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.sign.R
\name{networks.sign}
\alias{networks.sign}
\title{Combine Signed Networks into a Multi- or Dynamic-Network Object}
\usage{
networks.sign(..., dynamic = FALSE, dual.sign = FALSE)
}
\arguments{
\item{...}{One or more signed networks (objects of class \code{"static.sign"}),
or a list of such networks.}

\item{dynamic}{Logical. If \code{TRUE}, treat input as a dynamic network;
otherwise as a multilayer network. Defaults to \code{FALSE}.}

\item{dual.sign}{Logical. If \code{TRUE}, disables the layer fixing constraint. Defaults to \code{FALSE}.}
}
\value{
A combined network object of class \code{"multi.sign"} or
  \code{"dynamic.sign"}, with the appropriate ERGM constraint formula.
}
\description{
Creates a composite network object from multiple signed networks,
suitable for ERGM modeling. Can represent either a multilayer
or dynamic signed network structure.
}
\examples{
data("tribes")
multi_net <- networks.sign(tribes, tribes)
dyn_net <- networks.sign(list(tribes, tribes), dynamic = TRUE)

}
