% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdqlmISVB.R
\name{exdqlmISVB}
\alias{exdqlmISVB}
\title{exDQLM - ISVB algorithm}
\usage{
exdqlmISVB(
  y,
  p0,
  model,
  df,
  dim.df,
  fix.gamma = FALSE,
  gam.init = NA,
  fix.sigma = TRUE,
  sig.init = NA,
  dqlm.ind = FALSE,
  exps0,
  tol = 0.1,
  n.IS = 500,
  n.samp = 200,
  PriorSigma = NULL,
  PriorGamma = NULL,
  verbose = TRUE
)
}
\arguments{
\item{y}{A univariate time-series.}

\item{p0}{The quantile of interest, a value between 0 and 1.}

\item{model}{List of the state-space model including \code{GG}, \code{FF}, prior parameters \code{m0} and \code{C0}.}

\item{df}{Discount factors for each block.}

\item{dim.df}{Dimension of each block of discount factors.}

\item{fix.gamma}{Logical value indicating whether to fix gamma at \code{gam.init}. Default is \code{FALSE}.}

\item{gam.init}{Initial value for gamma (skewness parameter), or value at which gamma will be fixed if \code{fix.gamma=TRUE}.}

\item{fix.sigma}{Logical value indicating whether to fix sigma at \code{sig.init}. Default is \code{TRUE}.}

\item{sig.init}{Initial value for sigma (scale parameter), or value at which sigma will be fixed if \code{fix.sigma=TRUE}.}

\item{dqlm.ind}{Logical value indicating whether to fix gamma at \code{0}, reducing the exDQLM to the special case of the DQLM. Default is \code{FALSE}.}

\item{exps0}{Initial value for dynamic quantile. If \code{exps0} is not specified, it is set to the DLM estimate of the \code{p0} quantile.}

\item{tol}{Tolerance for convergence of dynamic quantile estimates. Default is \code{tol=0.1}.}

\item{n.IS}{Number of particles for the importance sampling of joint variational distribution of sigma and gamma. Default is \code{n.IS=500}.}

\item{n.samp}{Number of samples to draw from the approximated posterior distribution. Default is \code{n.samp=200}.}

\item{PriorSigma}{List of parameters for inverse gamma prior on sigma; shape \code{a_sig} and scale \code{b_sig}. Default is an inverse gamma with mean 1 (or \code{sig.init} if provided) and variance 10.}

\item{PriorGamma}{List of parameters for truncated student-t prior on gamma; center \code{m_gam}, scale \code{s_gam} and degrees of freedom \code{df_gam}. Default is a standard student-t with 1 degree of freedom, truncated to the support of gamma.}

\item{verbose}{Logical value indicating whether progress should be displayed.}
}
\value{
A object of class "\code{exdqlmISVB}" containing the following:
\itemize{
\item \code{y} - Time-series data used to fit the model.
\item \code{run.time} - Algorithm run time in seconds.
\item \code{iter} - Number of iterations until convergence was reached.
\item \code{dqlm.ind} - Logical value indicating whether gamma was fixed at \code{0}, reducing the exDQLM to the special case of the DQLM.
\item \code{model} - List of the state-space model including \code{GG}, \code{FF}, prior parameters \code{m0} and \code{C0}.
\item \code{p0} - The quantile which was estimated.
\item \code{df} - Discount factors used for each block.
\item \code{dim.df} - Dimension used for each block of discount factors.
\item \code{sig.init} - Initial value for sigma, or value at which sigma was fixed if \code{fix.sigma=TRUE}.
\item \code{seq.sigma} - Sequence of sigma estimated by the algorithm until convergence.
\item \code{samp.theta} - Posterior sample of the state vector variational distribution.
\item \code{samp.post.pred} - Sample of the posterior predictive distributions.
\item \code{map.standard.forecast.errors} - MAP standardized one-step-ahead forecast errors.
\item \code{samp.sigma} - Posterior sample of scale parameter sigma variational distribution.
\item \code{samp.vts} - Posterior sample of latent parameters, v_t, variational distributions.
\item \code{theta.out} - List containing the variational distribution of the state vector including filtered distribution parameters (\code{fm} and \code{fC}) and smoothed distribution parameters (\code{sm} and \code{sC}).
\item \code{vts.out} - List containing the variational distributions of latent parameters v_t.
\item \code{fix.sigma} Logical value indicating whether sigma was fixed at \code{sig.init}.
}
If \code{dqlm.ind=FALSE}, the object also contains:
\itemize{
\item \code{gam.init} - Initial value for gamma, or value at which gamma was fixed if \code{fix.gamma=TRUE}.
\item \code{seq.gamma} - Sequence of gamma estimated by the algorithm until convergence.
\item \code{samp.gamma} - Posterior sample of skewness parameter gamma variational distribution.
\item \code{samp.sts} - Posterior sample of latent parameters, s_t, variational distributions.
\item \code{gammasig.out} - List containing the IS estimate of the variational distribution of sigma and gamma.
\item \code{sts.out} - List containing the variational distributions of latent parameters s_t.
\item \code{fix.gamma} Logical value indicating whether gamma was fixed at \code{gam.init}.
}
Or if \code{dqlm.ind=TRUE}, the object also contains:
\itemize{
\item \code{sig.out} - List containing the IS estimate of the variational distribution of sigma.
}
}
\description{
The function applies an Importance Sampling Variational Bayes (ISVB) algorithm to estimate the posterior of an exDQLM.
}
\examples{
\donttest{
y = scIVTmag[1:1095]
trend.comp = polytrendMod(1,mean(y),10)
seas.comp = seasMod(365,c(1,2,4),C0=10*diag(6))
model = trend.comp + seas.comp
M0 = exdqlmISVB(y,p0=0.85,model,df=c(1,1),dim.df = c(1,6),
                 gam.init=-3.5,sig.init=15,tol=0.05)
}

}
