% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{TuneCStatisticLogit}
\alias{TuneCStatisticLogit}
\title{Tuning function (logistic regression)}
\usage{
TuneCStatisticLogit(scaling_factor, crude_log_odds, auc = NULL)
}
\arguments{
\item{scaling_factor}{constant by which log-odds (or beta coefficients when
there is no intercept) are multiplied.}

\item{crude_log_odds}{vector of log-odds to be multiplied by the
\code{scaling_factor}.}

\item{auc}{desired concordance statistic (area under the ROC curve). If
\code{auc=NULL}, the obtained concordance statistic is returned.}
}
\value{
The absolute difference between desired and expected concordance (if
  \code{auc} is provided) or expected concordance (if \code{auc=NULL}).
}
\description{
Computes the difference in absolute value between the desired and expected C
statistic given the vector of true probabilities.
}
\keyword{internal}
