% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baidu.R, R/bing.R, R/caiyun.R, R/chatglm.r,
%   R/deepseek.r, R/qwen.r, R/tencent.r, R/translate.r, R/volcengine.r,
%   R/youdao.r
\name{baidu_translate}
\alias{baidu_translate}
\alias{bing_translate}
\alias{caiyun_translate}
\alias{chatglm_translate}
\alias{dsk_translate}
\alias{qwen_translate}
\alias{tencent_translate}
\alias{en2cn}
\alias{cn2en}
\alias{translate}
\alias{volcengine_translate}
\alias{youdao_translate}
\title{translate}
\usage{
baidu_translate(x, from = "en", to = "zh")

bing_translate(x, from = "en", to = "zh")

caiyun_translate(x, from = "auto", to = "zh")

chatglm_translate(x, from = "en", to = "zh")

dsk_translate(x, from = "en", to = "zh")

qwen_translate(x, from = "en", to = "zh")

tencent_translate(x, from = "en", to = "zh")

en2cn(x)

cn2en(x)

translate(x, from = "en", to = "zh")

volcengine_translate(x, from = "en", to = "zh")

youdao_translate(x, from = "en", to = "zh")
}
\arguments{
\item{x}{query sentences}

\item{from}{source language, i.e., the language to be translated}

\item{to}{target language, i.e., the language to be translated into}
}
\value{
the translated sentences
}
\description{
Translate query sentences
}
\details{
This function use online translator API (one of Baidu, bing, youdao, volcengine, caiyun, tencent and LLM) to translate query sentences
}
\examples{
\dontshow{if (fanyi_has_appkey('baidu')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
baidu_translate('hello world')
\dontshow{\}) # examplesIf}
library(fanyi)
## set your appid and key once in your R session
#
# set_translate_option(appid = 'your_appid', key = 'your_key', source = 'which_translation_service')
#
# translate('hello world', from = 'en', to = 'zh')
}
\author{
Guangchuang Yu
}
