% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{read_data_file}
\alias{read_data_file}
\title{Read a data file based on metadata and codes dictionary}
\usage{
read_data_file(file, metadata, dict)
}
\arguments{
\item{file}{A character string specifying the path to the data file.}

\item{metadata}{A list containing the scenario and variable information obtained
from the metadata file using \code{\link{process_metadata_file}}.}

\item{dict}{A data frame containing codes dictionary information.}
}
\value{
A tibble containing the processed data.
}
\description{
\code{read_data_file()} reads a data file and processes it based on the provided metadata
and codes dictionary. The processing depends on the metadata scenario, which
includes cases like \code{"single"}, \code{"single_multiple"}, and \code{"single_multiple_single"}.
For certain scenarios, the function utilizes \code{read.csv} to infer column
types without explicit specification.
}
\details{
\code{read_data_file()} reads the data file and applies necessary processing based
on the metadata scenario. For scenarios like \code{"single"} and \code{"single_multiple"}, it
uses \code{read.csv} for convenient type inference. For \code{"single_multiple_single"},
it reads the file line by line, collapses every \code{(N_CODES + 2)} lines, and then reads
the collapsed lines using \code{read.table}.
}
