% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_multiflashlight.R
\name{print.multiflashlight}
\alias{print.multiflashlight}
\title{Prints a multiflashlight}
\usage{
\method{print}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class "multiflashlight".}

\item{...}{Further arguments passed to \code{\link[=print.flashlight]{print.flashlight()}}.}
}
\value{
Invisibly, the input is returned.
}
\description{
Print method for an object of class "multiflashlight".
}
\examples{
fit_lm <- lm(Sepal.Length ~ ., data = iris)
fit_glm <- glm(Sepal.Length ~ ., family = Gamma(link = log), data = iris)
fl_lm <- flashlight(model = fit_lm, label = "lm")
fl_glm <- flashlight(model = fit_glm, label = "glm")
multiflashlight(list(fl_lm, fl_glm), data = iris)
}
\seealso{
\code{\link[=multiflashlight]{multiflashlight()}}
}
