% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lin}
\alias{fn_lin}
\title{Linear function}
\usage{
fn_lin(t, m, b)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{m}{The slope of the line.}

\item{b}{The intercept (function value when \code{t = 0}).}
}
\value{
A numeric vector of the same length as \code{t}, giving the linear function values.
}
\description{
A basic linear function of the form \code{f(t) = m * t + b}, where \code{m}
is the slope and \code{b} is the intercept.
}
\details{
\if{html}{
\deqn{
f(t; m, b) = m \cdot t + b
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lin",
  params = c(m = 2, b = 10),
  interval = c(0, 108),
  n_points = 2000
)
}
