% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lin_plat}
\alias{fn_lin_plat}
\title{Linear plateau function}
\usage{
fn_lin_plat(t, t1 = 45, t2 = 80, k = 0.9)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{t1}{The onset time of the response. The function is 0 for all values less than \code{t1}.}

\item{t2}{The time at which the plateau begins. Must be greater than \code{t1}.}

\item{k}{The height of the plateau. The function linearly increases from
0 to \code{k} between \code{t1} and \code{t2}, then remains constant.}
}
\value{
A numeric vector of the same length as \code{t}, representing the function values.
}
\description{
A simple piecewise function that models a linear increase from zero to a plateau.
The function rises linearly between two time points and then levels off at a constant value.
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, k) =
\begin{cases}
0 & \text{if } t < t_1 \\
\dfrac{k}{t_2 - t_1} \cdot (t - t_1) & \text{if } t_1 \leq t \leq t_2 \\
k & \text{if } t > t_2
\end{cases}
}
}

This function is continuous but not differentiable at \code{t1} and \code{t2}
due to the piecewise transitions. It is often used in agronomy and ecology
to describe growth until a resource limit or developmental plateau is reached.
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lin_plat",
  params = c(t1 = 34.9, t2 = 61.8, k = 100),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3
)
}
