% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tkl.R
\name{tkl}
\alias{tkl}
\title{Optimize TKL parameters to find a solution with target RMSEA and CFI values}
\usage{
tkl(mod, target_rmsea = NULL, target_cfi = NULL, tkl_ctrl = list())
}
\arguments{
\item{mod}{A \code{\link[fungible]{simFA}} model object.}

\item{target_rmsea}{(scalar) Target RMSEA value.}

\item{target_cfi}{(scalar) Target CFI value.}

\item{tkl_ctrl}{(list) A control list containing the following TKL-specific
arguments:
\itemize{
\item weights (vector) Vector of length two indicating how much weight to give
RMSEA and CFI, e.g., \code{c(1,1)} (default) gives equal weight
to both indices; \code{c(1,0)} ignores the CFI value.
\item v_start (scalar) Starting value to use for \eqn{\nu}, the proportion
of uniqueness variance reallocated to the minor common factors. Note that
only \code{v} as a proportion of the unique (not total) variance is supported
in this function.
\item eps_start (scalar) Starting value to use for \eqn{\epsilon}, which
controls how common variance is distributed among the minor common factors.
\item v_start (vector) A vector of length two specifying the lowest and highest acceptable values of \eqn{\nu}.
\item eps_start (vector) A vector of length two specifying the lowest and highest acceptable values of \eqn{\epsilon}.
\item NMinorFac (scalar) Number of minor common factors.
\item WmaxLoading (scalar) Threshold value for \code{NWmaxLoading}.
\item NWmaxLoading (scalar) Maximum number of absolute loadings \eqn{\ge}
\code{WmaxLoading} in any column of \eqn{W}.
\item penalty (scalar) Penalty applied to objective function if the
\code{NmaxLoading} condition isn't satisfied.
\item optim_type (character)  Which optimization function to use,
\code{\link[stats]{optim}} or \code{\link[GA]{ga}}?
\code{\link[stats]{optim}} is faster, but might not converge in some cases.
If \code{\link[stats]{optim}} doesn't converge, \link[GA]{ga} will be used
as a fallback option.
\item max_tries (numeric) How many times to restart optimization with new start
parameter values if optimization doesn't converge?
\item factr (numeric) controls the convergence of the "L-BFGS-B" method.
Convergence occurs when the reduction in the objective is within this
factor of the machine tolerance. Default is 1e7, that is a tolerance of
about 1e-8. (when using \code{\link[stats]{optim}}).
\item maxit (number) Maximum number of iterations to use (when using
\code{\link[stats]{optim}}).
\item ncores (boolean/scalar) Controls whether \link[GA]{ga} optimization is done in
parallel. If \code{TRUE}, uses the maximum available number of processor cores.
If \code{FALSE}, does not use parallel processing. If an integer is provided,
that's how many processor cores will be used (if available).
}}
}
\description{
Find the optimal W matrix such that the RMSEA and CFI values are as close as
possible to the user-specified target values.
}
\details{
This function attempts to find optimal values of the TKL parameters
\eqn{\nu} and \eqn{\epsilon} such that the resulting correlation
matrix with model error (\eqn{\Sigma}) has population RMSEA and/or CFI
values that are close to the user-specified values. It is important to note
that solutions are not guaranteed to produce RMSEA and CFI values that are
reasonably close to the target values; in fact, some combinations of RMSEA
and CFI will be difficult or impossible to obtain for certain models (see
Lai & Green, 2016). It can be particularly difficult to find good solutions
when additional restrictions are placed on the minor factor loadings (i.e.,
using the \code{WmaxLoading} and \code{NWmaxLoading} arguments).

Optimization is fastest when the \code{optim_type = optim} optimization method
is chosen. This indicates that optimization should be done using the
\code{L-BFGS-B} algorithm implemented in the \code{\link[stats]{optim}}
function. However, this method can sometimes fail to find a solution.
In that case, I recommend setting \code{optim_type = ga}, which indicates that a
genetic algorithm (implemented in \code{\link[GA]{ga}}) will be used.
This method takes longer than \code{\link{optim}} but is more likely to
find a solution.
}
\references{
Tucker, L. R., Koopman, R. F., & Linn, R. L. (1969). Evaluation
of factor analytic research procedures by means of simulated correlation
matrices. \emph{Psychometrika}, \emph{34}(4), 421–459.
}
